/**
 * @file    wm_cloud.h
 *
 * @brief   Cloud Interface API
 *
 * @author  winnermicro
 *
 * Copyright (c) 2015 Winner Microelectronics Co., Ltd.
 */
#ifndef __WM_CLOUD_H__
#define __WM_CLOUD_H__

#include "wm_config.h"
#if TLS_CONFIG_CLOUD
#include "wm_socket.h"
#if TLS_CONFIG_HTTP_CLIENT_SECURE
#include "matrixsslApi.h"
#endif
#include <stdint.h>
#define SERVER_STATE_OFFLINE 0
#define SERVER_STATE_ONLINE 1

#define SOCKET_TCP 1
#define SOCKET_CLINET 2
#define SOCKET_SSL  4

/**
 * ԶsocketϢĿǰsock_type֧Tcp server
 * ֧udptcp clientԼssltcp
 */
typedef struct _SOCKET{
	int socket_num;  			/**< socketţsocketɹϵͳ룬
										߳ʼʱд */
	struct sockaddr * sock_addr;/**< socketַudpʱʾصַ
										tcpʱʾԶ˵ַ */
	u8 sock_type; 				/**< socketͶ壬ĿǰbitЧ
										鿴SOCKET_xxx */
	u8 connected;  				/**< socketӱ־tcp clientЧ
										Ϊ1ʾӳɹ */
	void * user_param;			/**< ԶϢǷΪ
										Զsocket */
#if TLS_CONFIG_HTTP_CLIENT_SECURE
	ssl_t * ssl; 				/**< sslϢSOCKET_SSLʱЧ */
#endif
}SOCKET;

/** Զsocketݵĸʽ */
typedef struct CReadData{
	SOCKET *socket;  			/**< socketϢ */
	char * read_data;			/**< յ */
	u32     data_len;  			/**< ݳ */
	struct sockaddr_in sin_recv;/**< ԶsocketַudpʱЧ */
}CloudReadData;

#if TLS_CONFIG_CLOUD_KII
/** ƶ˻صݸʽ */
typedef struct _Cloud_Callback_data
{
	char* bucketName;/**< bucket */
	char* objectId;  /**< id */
	char* jsonObject;/**< ݣͨjsonʽʾ */
} CloudCallbackData, *PCloudCallbackData;
/** ϴƶ˻صerrcodeΪ0ʾϴɹdataΪϴݣ
ϴɹԴdata->objectIdõϴƵݶid */
typedef void (*upload_callback)(PCloudCallbackData data, int errcode);
/** ϴƶ˵ݸʽ */
typedef struct _CloudData
{
	char* bucketName;    /**< bucket */
	char* jsonObject;    /**< ݣͨjsonʽʾ */
	upload_callback cb;  /**< ϴص */
} CloudData,*PCloudData;

/** ʼƲ */
typedef struct _Cloud_Init_arg
{
	char* site;       /**< ַĿǰɴ"CN" "US" "JP" "SG" */
	char* appId;      /**< ӦID */
	char* appKey;     /**< ӦKey */
	char* deviceType; /**< 豸 */
	char* venderId;   /**< 豸IDͨΪ豸MACַ */
	char* modelName;  /**< ģƣԶַOTA͵bucketNameʽΪ */
	char* password;   /**< 豸 */
	char* recvDataBucket;    /**< 豸͵bucketName */
} CloudInitArg, *PCloudInitArg;
#endif

#if TLS_CONFIG_CLOUD_JD
/** Ʋö */
enum cloud_opt_type
{
	UPLOAD_REQ,    	/**< ϴ */
	UPLOAD_RESP,    /**< ϴӦ */
	CONTROL_REQ,    /**< ƶ˿ */
	CONTROL_RESP,   /**< Ӧ */
	SNAPSHOT_REQ,   /**< ƶץȡգ״̬ */
	SNAPSHOT_RESP   /**< գ״̬Ӧ */
};

/**
 *  ƶͨݽṹҪעһ:
 *	1)Ϊtls_cloud_upload_data:
 *	 ϴ󡢿Ӧգ״̬Ӧӿڣ
 *	 ϴ˽ӿڷغdata->optΪUPLOAD_RESP
 *	 ʵͬӦϴʱdata->resultΪϴݺƶ˷ؽ
 *	 CloudDataҪԼڴ棬Լͷš
 *	2)Ϊcloud_callbackص:
 *	ϴӦƶ˿´ƶץȡգ״̬ʱ
 *	cloud_callbackصӿڱá
 *	ƶ˿ƶץȡڴ˻صӿڷغ
 *	data->optΪCONTROL_RESPSNAPSHOT_RESPʵͬӦ˴
 *	ʱdata->resultΪӦdata->valuesа˿Ӧ
 *	ͬӦSNAPSHOT_RESPʱnamesvaluesֵڴԼͬӦCONTROL_RESPʱ
 *	data->control_respֵڴɿ룬ʵͷš
 */
typedef struct _CloudData
{
	enum cloud_opt_type opt;/**< ö */
	int result;    		/**< ƶӦϴݻ豸Ӧƶ˿ƽ */
	char* control_resp; /**< ƶ˿ʧԭ */
	char** names;  		/**< ϴƶ˿
							 ƶ˿Ӧֶ */
	char** values;    	/**< ϴƶ˿󡢿Ӧֵ */
	int cnt;    		/**< ֶθ */
	void * arg;    		/**< ƶ˷͹ĲҪԭⲻشƶ */
} CloudData,*PCloudData, CloudCallbackData, *PCloudCallbackData;
/** ʼƲ壬Ӧôproduct_uuid */
typedef struct _Cloud_Init_arg
{
	char *product_uuid;    /**< ƷUUID */
} CloudInitArg, *PCloudInitArg;
#endif
#if TLS_CONFIG_CLOUD_GAGENT

/** ƶͨݽṹ */
typedef struct _CloudData
{
    int32_t totalcap;    /**< ȫֻĴС 4k+128byte */
    int32_t remcap;      /**< ݰͷ೤ 128byte */
    uint8_t *allbuf;     /**< ʼַ */
    int32_t bufcap;      /**< ĴС 4K */

    uint32_t type;       /**< Ϣ */
    uint8_t *phead;      /**< ݰͷʼַ */
    uint8_t *ppayload;   /**< ҵ߼ͷʼַ */
    uint8_t *pend;       /**< ݽַ */
    uint8_t initiative_report;    /**<Ƿϱ 1-ϱ 0-APPϱ */
} CloudData,*PCloudData, CloudCallbackData, *PCloudCallbackData;

/** ʼƲ */
typedef struct _Cloud_Init_arg
{
	char* product_key;    	/**< Ʒʶ */
	char* wifi_soft_ver;    /**< 汾 */
	char* wifi_hard_ver;    /**< Ӳ汾 */
} CloudInitArg, *PCloudInitArg;
#endif
#if TLS_CONFIG_CLOUD_360
/**
 *          ϴƶ˻صerrcodeΪ0ʾϴɹuser_paramΪ
 *          tls_cloud_upload_dataʱCloudDataеuser_param
 */
typedef void (*upload_callback)(void* user_param, int errcode);

/** ƶ˻صݸʽ */
typedef struct _Cloud_Callback_data
{
    const uint8_t* data;    /**<  */
    size_t datalen;    		/**< ݳ */
}CloudCallbackData, *PCloudCallbackData;

/** ϴƶ˵ݸʽ */
typedef struct _CloudData
{
    void* user_param;    	/**< ûϴصд˲ */
    const uint8_t* data;    /**<  */
    size_t datalen;    		/**< ݳ */
    upload_callback cb;    	/**< ϴص */
} CloudData,*PCloudData;

/** ʼƲ */
typedef struct _Cloud_Init_arg
{
	int product_id;    				/**< ƷID */
	unsigned char product_aes[16];  /**< ƷAESԿ */
	char *device_name;    			/**< 豸 */
} CloudInitArg, *PCloudInitArg;
#endif

#if TLS_CONFIG_CLOUD_QQ

/**
 *          ϴƶ˻صerrcodeΪ0ʾϴɹcookieΪ
 *          ţڵtls_cloud_upload_dataʱõCloudData
 *          pCookieͬ
 *
 */
typedef void (*upload_callback)(int32_t err_code, uint32_t cookie);

/** ƶ˻صݸʽ */
typedef struct  _Cloud_Callback_data {
    uint32_t property_id;    	   /**< ID */
    uint8_t *property_value;       /**< valueΪֽ */
    uint32_t property_value_len;   /**< valueĳ */
    uint32_t seq;    	/**<  */
    int32_t  ret_code;  /**< յcc datapointظACKʱôֵH5ҳʹ */
} CloudCallbackData, *PCloudCallbackData;

/** ϴƶ˵ݸʽ */
typedef struct _CloudData
{
	CloudCallbackData *datapoints;    	/**< ݽṹ */
	uint32_t datapoints_count;    		/**<  */
	upload_callback cb;    				/**< ϴص */
	uint32_t *pCookie;    				/**<  */
}CloudData,*PCloudData;

/** ʼƲ */
typedef struct _Cloud_Init_arg{
    /* ӲϢ */
    char*    device_name;    /**< 豸,'\0'βַȲ32ֽڣ
    							  nettypeΪ1ʱվעdevicenameһ */
    char*    sn;    		/**< 豸к,'\0'βַȱ16ֽ */
    char*    license;    	/**< 豸LICENSE */
    int32_t  product_id;    /**< ÿһ̵ÿһ͵豸Ӧһid */
    int32_t  product_version;    /**< Ʒİ汾ϢOTAĬ0 */
    /** ԿϢ */
    uint8_t* client_pub_key;    /**< clientԿÿ̨豸ɺ¼豸 */
    int32_t  client_pub_key_len;
    uint8_t* auth_key;    		/**< authkeyÿ̨豸ɺ¼豸 */
    int32_t  auth_key_len;
} CloudInitArg, *PCloudInitArg;
#endif
#if TLS_CONFIG_CLOUD_ABLECLOUD

/** ABLECLOUDƶͨݽṹ */
typedef struct _CloudData
{
    u8 msg_id;    /**< ϢIDӦϢͬƶ·ϢIDϴ */
    u8 msg_code;  /**< ϢCodeӦϢͬƶ·Ϣcode
    				   ϴҪ200 */
    u8 *data;    /**<  */
    uint32 datalen;    /**< ݳ */
} CloudData,*PCloudData, CloudCallbackData, *PCloudCallbackData;

/** ʼƲ */
typedef struct _Cloud_Init_arg
{
	u32 major_domain;    	/**< ID */
	u16 sub_domain;    		/**< ID */
	u8 private_key[112];    /**< Ʒ˽Կ */
	u32 product_version;    /**< Ʒİ汾ϢOTA */
} CloudInitArg, *PCloudInitArg;
#endif
#if TLS_CONFIG_CLOUD_ELIAN
enum
{
	DATA_TYPE_BINARY = 0,    /**<  */
	DATA_TYPE_TEXT = 1,      /**< ıʽ */
	DATA_TYPE_NV = 2,        /**< ԿոӲĸʽ
								  磺power 34 */
	DATA_TYPE_EL_CMD = 3,    /**< Ϊ4ֽId+4ֵֽ
								  磺140 (Դ״̬ϱ14Ϊ
								  0ҲΪʾ״̬ */
	DATA_TYPE_INFRA = 6,     /**< ʽ */
	DATA_TYPE_STATUS_REQ = 7,/**< 豸״̬ */
	DATA_TYPE_EL_CMD2 = 8    /**< Ϊ4ֽId+ַʽֵ
								  磺140 (Դ״̬ϱ14Ϊ
								  0Ϊַʾ״̬) */
};

/** ƶͨݽṹ */
typedef struct _CloudData
{
    const uint8_t* data;    /**<  */
    size_t datalen;    		/**< ݳ */
    u8 datatype;
} CloudData,*PCloudData, CloudCallbackData, *PCloudCallbackData;

/** ʼƲ */
typedef struct _Cloud_Init_arg
{
	char*                 sn;    /**< 豸к,'\0'βַ
									  13ֽ */
} CloudInitArg, *PCloudInitArg;
#endif

/** 豸ƶעõĹ豸Ϣ */
typedef struct _Cloud_Dev_info{
	u8* device_id;    	 /**< 豸ID */
	u8* access_token;    /**< 豸token豸IDһ𹹳豸Ƶƾ֤ */
}CloudDeviceInfo, *PCloudDeviceInfo;


/**
 * @brief          ƵĻص
 *
 * @param[in]      data    
 *
 * @retval         0     success
 * @retval         other failed
 *
 * @note           None
 */
typedef int (*cloud_callback)(PCloudCallbackData data);

/**
 * @brief          ״̬ĻصstatusΪ1ʾ豸ߣstatusΪ0ʾ
                   豸
 *
 * @param[in]      status    
 *
 * @retval         0 ʾ豸
 * @retval         1 ʾ豸
 *
 * @note           None
 */
typedef void (*cloud_online_status_callback)(int status);

/**
 * @defgroup APP_APIs APP APIs
 * @brief APP APIs
 */

/**
 * @addtogroup APP_APIs
 * @{
 */

/**
 * @defgroup cloud_APIs cloud APIs
 * @brief cloud APIs
 */

/**
 * @addtogroup cloud_APIs
 * @{
 */

/**
 * @brief          ʼƣuser taskʼʱã
 				   ԾƣargΪproduct_uuid
 				   arg鿴CloudInitArgṹ
 *
 * @param[in]      arg
 *
 * @retval         0     success
 * @retval         other failed
 *
 * @note           None
 */
int tls_cloud_init(PCloudInitArg arg);

/**
 * @brief          עƣ豸ʱãԴblockΪ0ʱ˺
                   أעںִ̨УblockΪ1ʱעɺ˺
                   ء
 *
 * @param[in]      block   ǷΪ1ʾֱעɷأ
 						   Ϊ0ʾأעںִ̨
 *
 * @return         None
 *
 * @note           None
 */
void tls_cloud_finish(u8 block);

/**
 * @brief          豸ϴݣԿӦϴ״̬Լ
                   յ
 *
 * @param[in]      data
 *
 * @retval         0     success
 * @retval         other failed
 *
 * @note           None
 */
int tls_cloud_upload_data(PCloudData data);

/**
 * @brief          ƵĻصӿڣ豸ƵĿϢȵ
                   Ψһӿ
 *
 * @param[in]      callback
 *
 * @retval         0     success
 * @retval         other failed
 *
 * @note           None
 */
int tls_cloud_set_callback(cloud_callback callback);

/**
 * @brief          ״̬Ļصӿڣ豸ߣʱص˽ӿ
 *
 * @param[in]      callback
 *
 * @return         None
 *
 * @note           None
 */
void tls_cloud_set_online_status_callback(cloud_online_status_callback callback);

/**
 * @brief          豸ƶע豸Ϣ
 				   鿴CloudDeviceInfoṹ
 *
 * @param[in]      info
 *
 * @retval         0     success
 * @retval         other failed
 *
 * @note           None
 */
int tls_cloud_get_device_info(PCloudDeviceInfo info);

/*
* externͷĺҪʵ֣ʵֲ鿴wm_lsd_device_found.cΪдһ豸ֵļʵ֣
* ߿ԸҪдԼ豸ʵ֣ǾͨſƵȡ
*/

/**
 * @brief          ÿԶsocketϢcountΪֵ֧socket
                   ݲͬƴ˲ͬ
 *
 * @param[in]      sockets
 * @param[in]      count
 *
 * @retval         0     success
 * @retval         other failed
 *
 * @note           None
 */
extern int tls_cloud_get_custom_sockets(SOCKET** sockets, int count);

/**
 * @brief          ԶsocketݵĴ˺socket
                   յʱã
                   ߿ɸSOCKETеuser_paramжǷΪԶsocket
                   ȻӦĴ
 *
 * @param[in]      data
 *
 * @retval         0     success
 * @retval         other failed
 *
 * @note           None
 */
extern int tls_cloud_socket_data_handler(CloudReadData* data);


/**
 * @brief          ͨsocketݣtotolenֻudpʱЧұ
                   tcpʱtoNULL
 *
 * @param[in]      *sock
 * @param[in]      *data
 * @param[in]      size
 * @param[in]      flags
 * @param[in]      *to
 * @param[in]      tolen
 *
 * @retval         0     success
 * @retval         other failed
 *
 * @note           None
 */
int tls_cloud_socket_sendto(SOCKET *sock, const void *data, size_t size, int flags,
       const struct sockaddr *to, socklen_t tolen);

/**
 * @}
 */

/**
 * @}
 */

#endif //TLS_CONFIG_CLOUD
#endif

