
/********************************** (C) COPYRIGHT *******************************
* File Name          : USBHOST.C
* Author             : WCH
* Version            : V1.1
* Date               : 2018/02/28
* Description        : CH554 USB ӿں
*******************************************************************************/

#include "..\..\Public\CH554.H"                                                 
#include "..\..\Public\Debug.H"
#include "stdio.h"
#include "string.h"
#include "USBHOST.H"

#include "CH554UFI.H"                                                        //ʹUSBH_HUB_KM.C ε

bit HubLowSpeed;
UINT8X  Com_Buffer[ COM_BUF_SIZE ];                                            // ûʱ,öʱڴ,öٽҲͨʱ
/*******************************************************************************
* Function Name  : DisableRootHubPort( )
* Description    : رHUB˿
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void  DisableRootHubPort( )          
{
#ifdef	FOR_ROOT_UDISK_ONLY
	CH554DiskStatus = DISK_DISCONNECT;
#endif
#ifndef	DISK_BASE_BUF_LEN
	ThisUsbDev.DeviceStatus = ROOT_DEV_DISCONNECT;
    ThisUsbDev.DeviceAddress = 0x00;
#endif
}
/*******************************************************************************
* Function Name  : AnalyzeRootHub(void)
* Description    : ROOT-HUB״̬,ROOT-HUB˿ڵ豸¼
                   豸γ,еDisableRootHubPort(),˿ڹر,¼,Ӧ˿ڵ״̬λ
* Input          : None
* Output         : None
* Return         : ERR_SUCCESSΪû,ERR_USB_CONNECTΪ⵽,ERR_USB_DISCONΪ⵽Ͽ
*******************************************************************************/
UINT8   AnalyzeRootHub( void )
{ 
	UINT8	s;
	s = ERR_SUCCESS;
	if ( USB_MIS_ST & bUMS_DEV_ATTACH ) {                                        // 豸
#ifdef DISK_BASE_BUF_LEN
		if ( CH554DiskStatus == DISK_DISCONNECT
#else
		if ( ThisUsbDev.DeviceStatus == ROOT_DEV_DISCONNECT                        // ⵽豸
#endif
			|| ( UHOST_CTRL & bUH_PORT_EN ) == 0x00 ) {                              // ⵽豸,δ,˵Ǹղ
			DisableRootHubPort( );                                                   // رն˿
#ifdef DISK_BASE_BUF_LEN
			CH554DiskStatus = DISK_CONNECT;
#else
//		ThisUsbDev.DeviceSpeed = USB_HUB_ST & bUHS_DM_LEVEL ? 0 : 1;
			ThisUsbDev.DeviceStatus = ROOT_DEV_CONNECTED;                            //ӱ־
#endif
#if DE_PRINTF
			printf( "USB dev in\n" );
#endif
			s = ERR_USB_CONNECT;
		}
	}
#ifdef DISK_BASE_BUF_LEN
	else if ( CH554DiskStatus >= DISK_CONNECT ) {
#else
	else if ( ThisUsbDev.DeviceStatus >= ROOT_DEV_CONNECTED ) {                  //⵽豸γ
#endif
		DisableRootHubPort( );                                                     // رն˿
#if DE_PRINTF		
		printf( "USB dev out\n" );
#endif
		if ( s == ERR_SUCCESS ) s = ERR_USB_DISCON;
	}
//	UIF_DETECT = 0;                                                            // жϱ־
	return( s );
}
/*******************************************************************************
* Function Name  : SetHostUsbAddr
* Description    : USBǰUSB豸ַ
* Input          : UINT8 addr
* Output         : None
* Return         : None
*******************************************************************************/
void    SetHostUsbAddr( UINT8 addr )
{
    USB_DEV_AD = USB_DEV_AD & bUDA_GP_BIT | addr & 0x7F;
}

#ifndef	FOR_ROOT_UDISK_ONLY
/*******************************************************************************
* Function Name  : SetUsbSpeed
* Description    : õǰUSBٶ
* Input          : UINT8 FullSpeed
* Output         : None
* Return         : None
*******************************************************************************/
void    SetUsbSpeed( UINT8 FullSpeed )  
{
    if ( FullSpeed )                                                           // ȫ
    {
        USB_CTRL &= ~ bUC_LOW_SPEED;                                           // ȫ
        UH_SETUP &= ~ bUH_PRE_PID_EN;                                          // ֹPRE PID
    }
    else
    {
        USB_CTRL |= bUC_LOW_SPEED;                                             // 		
    }
}
#endif

/*******************************************************************************
* Function Name  : ResetRootHubPort( )
* Description    : ⵽豸,λ,Ϊö豸׼,ΪĬΪȫ
* Input          : None   
* Output         : None
* Return         : None
*******************************************************************************/
void  ResetRootHubPort( )
{
    UsbDevEndp0Size = DEFAULT_ENDP0_SIZE;                                      //USB豸Ķ˵0ߴ
#ifndef DISK_BASE_BUF_LEN	
    memset( &ThisUsbDev,0,sizeof(ThisUsbDev));                                 //սṹ
#endif	
	SetHostUsbAddr( 0x00 );
    UHOST_CTRL &= ~bUH_PORT_EN;                                                // ص˿
	SetUsbSpeed( 1 );                                                          // ĬΪȫ
	UHOST_CTRL = UHOST_CTRL & ~ bUH_LOW_SPEED | bUH_BUS_RESET;                 // ĬΪȫ,ʼλ
    mDelaymS( 20 );                                                            // λʱ10mS20mS
    UHOST_CTRL = UHOST_CTRL & ~ bUH_BUS_RESET;                                 // λ
    mDelayuS( 250 );
    UIF_DETECT = 0;                                                            // жϱ־
}
/*******************************************************************************
* Function Name  : EnableRootHubPort( )
* Description    : ʹROOT-HUB˿,ӦbUH_PORT_EN1˿,豸Ͽܵ·ʧ
* Input          : None
* Output         : None
* Return         : ERR_SUCCESSΪ⵽,ERR_USB_DISCONΪ
*******************************************************************************/
UINT8   EnableRootHubPort( )
{
#ifdef DISK_BASE_BUF_LEN
	if ( CH554DiskStatus < DISK_CONNECT ) CH554DiskStatus = DISK_CONNECT;
#else
	if ( ThisUsbDev.DeviceStatus < ROOT_DEV_CONNECTED ) ThisUsbDev.DeviceStatus = ROOT_DEV_CONNECTED;
#endif
	if ( USB_MIS_ST & bUMS_DEV_ATTACH ) {                                        // 豸
#ifndef DISK_BASE_BUF_LEN
		if ( ( UHOST_CTRL & bUH_PORT_EN ) == 0x00 ) {                              // δʹ
			ThisUsbDev.DeviceSpeed = USB_MIS_ST & bUMS_DM_LEVEL ? 0 : 1;
			if ( ThisUsbDev.DeviceSpeed == 0 ) UHOST_CTRL |= bUH_LOW_SPEED;          // 
		}
#endif
		USB_CTRL |= bUC_DMA_EN;                                                    // USBDMA,жϱ־δǰԶͣ
		UH_SETUP = bUH_SOF_EN;		
		UHOST_CTRL |= bUH_PORT_EN;                                                 //ʹHUB˿
		return( ERR_SUCCESS );
	}
	return( ERR_USB_DISCON );
}
#ifndef DISK_BASE_BUF_LEN
/*******************************************************************************
* Function Name  : SelectHubPort( UINT8 HubPortIndex )
* Description    : ѡҪHUB
* Input          : UINT8 HubPortIndex ѡָROOT-HUB˿ڵⲿHUBָ˿
* Output         : None
* Return         : None
*******************************************************************************/
void    SelectHubPort( UINT8 HubPortIndex )  
{ 
    if( HubPortIndex )                                                         // ѡָROOT-HUB˿ڵⲿHUBָ˿
    {
        SetHostUsbAddr( DevOnHubPort[HubPortIndex-1].DeviceAddress );          // USBǰUSB豸ַ
        SetUsbSpeed( DevOnHubPort[HubPortIndex-1].DeviceSpeed );               // õǰUSBٶ
		if ( DevOnHubPort[HubPortIndex-1].DeviceSpeed == 0 )                   // ͨⲿHUBUSB豸ͨѶҪǰID
        {
            UH_SETUP |= bUH_PRE_PID_EN;                                        // PRE PID
            HubLowSpeed = 1;
			mDelayuS(100);
        }
    }
    else                                                                       
    {
        HubLowSpeed = 0;        			
        SetHostUsbAddr( ThisUsbDev.DeviceAddress );                            // USBǰUSB豸ַ
        SetUsbSpeed( ThisUsbDev.DeviceSpeed );                                 // USB豸ٶ
    }
}
#endif
/*******************************************************************************
* Function Name  : WaitUSB_Interrupt
* Description    : ȴUSBж
* Input          : None
* Output         : None
* Return         : ERR_SUCCESS ݽջ߷ͳɹ
                   ERR_USB_UNKNOWN ݽջ߷ʧ
*******************************************************************************/
UINT8 WaitUSB_Interrupt( void )
{
    UINT16  i;
    for ( i = WAIT_USB_TOUT_200US; i != 0 && UIF_TRANSFER == 0; i -- ){;}
    return( UIF_TRANSFER ? ERR_SUCCESS : ERR_USB_UNKNOWN );
}
/*******************************************************************************
* Function Name  : USBHostTransact
* Description    : CH554,ĿĶ˵ַ/PID,ͬ־,20uSΪλNAKʱ(0,0xFFFF),0ɹ,ʱ/
                   ӳ,ʵӦ,Ϊṩٶ,ӦöԱӳŻ
* Input          : UINT8 endp_pid ƺ͵ַ  endp_pid: 4λtoken_pid, 4λǶ˵ַ
                   UINT8 tog      ͬ־
                   UINT16 timeout ʱʱ
* Output         : None
* Return         : ERR_USB_UNKNOWN ʱӲ쳣
                   ERR_USB_DISCON  豸Ͽ
                   ERR_USB_CONNECT 豸
                   ERR_SUCCESS     
*******************************************************************************/
UINT8   USBHostTransact( UINT8 endp_pid, UINT8 tog, UINT16 timeout )
{
//	UINT8	TransRetry;
#define	TransRetry	UEP0_T_LEN	                                               // Լڴ
	UINT8	s, r;
	UINT16	i;
	UH_RX_CTRL = UH_TX_CTRL = tog;
	TransRetry = 0;
	
	do {
		UH_EP_PID = endp_pid;                                                      // ָPIDĿĶ˵
		UIF_TRANSFER = 0;                                                          // 
//  s = WaitUSB_Interrupt( );
		for ( i = WAIT_USB_TOUT_200US; i != 0 && UIF_TRANSFER == 0; i -- );
		UH_EP_PID = 0x00;                                                          // ֹͣUSB
//	if ( s != ERR_SUCCESS ) return( s );  // жϳʱ,Ӳ쳣
		if ( UIF_TRANSFER == 0 ) return( ERR_USB_UNKNOWN );
		if ( UIF_DETECT ) {                                                        // USB豸¼
//			mDelayuS( 200 );                                                       // ȴ
			UIF_DETECT = 0;                                                          // жϱ־
			s = AnalyzeRootHub( );                                                   // ROOT-HUB״̬
			if ( s == ERR_USB_CONNECT ) FoundNewDev = 1;
#ifdef DISK_BASE_BUF_LEN
			if ( CH554DiskStatus == DISK_DISCONNECT ) return( ERR_USB_DISCON );      // USB豸Ͽ¼
			if ( CH554DiskStatus == DISK_CONNECT ) return( ERR_USB_CONNECT );        // USB豸¼
#else
			if ( ThisUsbDev.DeviceStatus == ROOT_DEV_DISCONNECT ) return( ERR_USB_DISCON );// USB豸Ͽ¼
			if ( ThisUsbDev.DeviceStatus == ROOT_DEV_CONNECTED ) return( ERR_USB_CONNECT );// USB豸¼
#endif
			mDelayuS( 200 );  // ȴ
		}
		if ( UIF_TRANSFER ) {  // 
			if ( U_TOG_OK ) return( ERR_SUCCESS );
			r = USB_INT_ST & MASK_UIS_H_RES;  // USB豸Ӧ״̬
			if ( r == USB_PID_STALL ) return( r | ERR_USB_TRANSFER );
			if ( r == USB_PID_NAK ) {
				if ( timeout == 0 ) return( r | ERR_USB_TRANSFER );
				if ( timeout < 0xFFFF ) timeout --;
				-- TransRetry;
			}
			else switch ( endp_pid >> 4 ) {
				case USB_PID_SETUP:
				case USB_PID_OUT:
//					if ( U_TOG_OK ) return( ERR_SUCCESS );
//					if ( r == USB_PID_ACK ) return( ERR_SUCCESS );
//					if ( r == USB_PID_STALL || r == USB_PID_NAK ) return( r | ERR_USB_TRANSFER );
					if ( r ) return( r | ERR_USB_TRANSFER );  // ǳʱ/,Ӧ
					break;  // ʱ
				case USB_PID_IN:
//					if ( U_TOG_OK ) return( ERR_SUCCESS );
//					if ( tog ? r == USB_PID_DATA1 : r == USB_PID_DATA0 ) return( ERR_SUCCESS );
//					if ( r == USB_PID_STALL || r == USB_PID_NAK ) return( r | ERR_USB_TRANSFER );
					if ( r == USB_PID_DATA0 && r == USB_PID_DATA1 ) {  // ͬ趪
					}  // ͬ
					else if ( r ) return( r | ERR_USB_TRANSFER );  // ǳʱ/,Ӧ
					break;  // ʱ
				default:
					return( ERR_USB_UNKNOWN );  // ܵ
					break;
			}
		}
		else {  // ж,Ӧ÷
			USB_INT_FG = 0xFF;  /* жϱ־ */
		}
		mDelayuS( 15 );	
	} while ( ++ TransRetry < 3 );
	return( ERR_USB_TRANSFER );  // Ӧʱ
}
/*******************************************************************************
* Function Name  : HostCtrlTransfer
* Description    : ִпƴ,8ֽpSetupReq,DataBufΪѡշ
* Input          : PUINT8X DataBuf Ҫպͷ,ôDataBufָЧڴź
                   PUINT8 RetLen  ʵʳɹշܳȱRetLenָֽڱ
* Output         : None
* Return         : ERR_USB_BUF_OVER IN״̬׶γ
                   ERR_SUCCESS     ݽɹ
                   ״̬
*******************************************************************************/
UINT8 HostCtrlTransfer( PUINT8X DataBuf, PUINT8 RetLen )  
{
    UINT16  RemLen  = 0;
    UINT8   s, RxLen, RxCnt, TxCnt;
    PUINT8  xdata   pBuf;
    PUINT8  xdata   pLen;
    pBuf = DataBuf;
    pLen = RetLen;
    mDelayuS( 200 );
    if ( pLen )
    {
        *pLen = 0;                                                              // ʵʳɹշܳ
    }
    UH_TX_LEN = sizeof( USB_SETUP_REQ );
    s = USBHostTransact( USB_PID_SETUP << 4 | 0x00, 0x00, 200000/20 );          // SETUP׶,200mSʱ
    if ( s != ERR_SUCCESS )
    {
        return( s );
    }
    UH_RX_CTRL = UH_TX_CTRL = bUH_R_TOG | bUH_R_AUTO_TOG | bUH_T_TOG | bUH_T_AUTO_TOG;// ĬDATA1
    UH_TX_LEN = 0x01;                                                           // Ĭݹ״̬׶ΪIN
    RemLen = (pSetupReq -> wLengthH << 8)|( pSetupReq -> wLengthL);
    if ( RemLen && pBuf )                                                       // Ҫշ
    {
        if ( pSetupReq -> bRequestType & USB_REQ_TYP_IN )                       // 
        {
            while ( RemLen )
            {
                mDelayuS( 200 );
                s = USBHostTransact( USB_PID_IN << 4 | 0x00, UH_RX_CTRL, 200000/20 );// IN
                if ( s != ERR_SUCCESS )
                {
                    return( s );
                }
                RxLen = USB_RX_LEN < RemLen ? USB_RX_LEN : RemLen;
                RemLen -= RxLen;
                if ( pLen )
                {
                    *pLen += RxLen;                                              // ʵʳɹշܳ
                }
//              memcpy( pBuf, RxBuffer, RxLen );
//              pBuf += RxLen;
                for ( RxCnt = 0; RxCnt != RxLen; RxCnt ++ )
                {
                    *pBuf = RxBuffer[ RxCnt ];
                    pBuf ++;
                }
                if ( USB_RX_LEN == 0 || ( USB_RX_LEN & ( UsbDevEndp0Size - 1 ) ) )
                {
                    break;                                                       // ̰
                }
            }
            UH_TX_LEN = 0x00;                                                    // ״̬׶ΪOUT
        }
        else                                                                     // 
        {
            while ( RemLen )
            {
                mDelayuS( 200 );
                UH_TX_LEN = RemLen >= UsbDevEndp0Size ? UsbDevEndp0Size : RemLen;
//              memcpy( TxBuffer, pBuf, UH_TX_LEN );
//              pBuf += UH_TX_LEN;
#ifndef DISK_BASE_BUF_LEN
                if(pBuf[1] == 0x09)                                              //HID
                {
                    Set_Port = Set_Port^1;
                    *pBuf = Set_Port;
#if DE_PRINTF									
                    printf("SET_PORT  %02X  %02X ",(UINT16)(*pBuf),(UINT16)(Set_Port));
#endif									
                }
#endif
                for ( TxCnt = 0; TxCnt != UH_TX_LEN; TxCnt ++ )
                {
                    TxBuffer[ TxCnt ] = *pBuf;
                    pBuf ++;
                }
                s = USBHostTransact( USB_PID_OUT << 4 | 0x00, UH_TX_CTRL, 200000/20 );// OUT
                if ( s != ERR_SUCCESS )
                {
                    return( s );
                }
                RemLen -= UH_TX_LEN;
                if ( pLen )
                {
                    *pLen += UH_TX_LEN;                                           // ʵʳɹշܳ
                }
            }
//          UH_TX_LEN = 0x01;                                                     // ״̬׶ΪIN
        }
    }
    mDelayuS( 200 );
    s = USBHostTransact( ( UH_TX_LEN ? USB_PID_IN << 4 | 0x00: USB_PID_OUT << 4 | 0x00 ), bUH_R_TOG | bUH_T_TOG, 200000/20 );  // STATUS׶
    if ( s != ERR_SUCCESS )
    {
        return( s );
    }
    if ( UH_TX_LEN == 0 )
    {
        return( ERR_SUCCESS );                                                    // ״̬OUT
    }
    if ( USB_RX_LEN == 0 )
    {
        return( ERR_SUCCESS );                                                    // ״̬IN,IN״̬ݳ
    }
    return( ERR_USB_BUF_OVER );                                                   // IN״̬׶δ
}
/*******************************************************************************
* Function Name  : CopySetupReqPkg
* Description    : ƿƴ
* Input          : PUINT8C pReqPkt ַ
* Output         : None
* Return         : None
*******************************************************************************/
void CopySetupReqPkg( PUINT8C pReqPkt )                                        // ƿƴ
{
    UINT8   i;
    if(HubLowSpeed)                                                               //HUBµ豸
    {
		((PUINT8X)pSetupReq)[ 0 ] = *pReqPkt;			
		for ( i = 1; i != sizeof( USB_SETUP_REQ )+1; i ++ )
		{
			((PUINT8X)pSetupReq)[ i ] = *pReqPkt;
			pReqPkt++;
		}
	}
    if(HubLowSpeed == 0)
    {
		for ( i = 0; i != sizeof( USB_SETUP_REQ ); i ++ )
		{
			((PUINT8X)pSetupReq)[ i ] = *pReqPkt;
			pReqPkt++;
		}			
    }
}
/*******************************************************************************
* Function Name  : CtrlGetDeviceDescr
* Description    : ȡ豸,TxBuffer
* Input          : None
* Output         : None
* Return         : ERR_USB_BUF_OVER ȴ
                   ERR_SUCCESS      ɹ
                   
*******************************************************************************/
UINT8   CtrlGetDeviceDescr( void )  
{
    UINT8   s;
    UINT8   len;
    UsbDevEndp0Size = DEFAULT_ENDP0_SIZE;
    CopySetupReqPkg( SetupGetDevDescr );
    s = HostCtrlTransfer( Com_Buffer, (PUINT8)&len );                                      // ִпƴ
    if ( s != ERR_SUCCESS )
    {
        return( s );
    }
    UsbDevEndp0Size = ( (PXUSB_DEV_DESCR)Com_Buffer ) -> bMaxPacketSize0;          // ˵0,Ǽ򻯴,ӦȻȡǰ8ֽںUsbDevEndp0Sizeټ
    if ( len < ( (PUSB_SETUP_REQ)SetupGetDevDescr ) -> wLengthL )
    {
        return( ERR_USB_BUF_OVER );                                              // ȴ
    }
    return( ERR_SUCCESS );
}
/*******************************************************************************
* Function Name  : CtrlGetConfigDescr
* Description    : ȡ,TxBuffer
* Input          : None
* Output         : None
* Return         : ERR_USB_BUF_OVER ȴ
                   ERR_SUCCESS      ɹ
                   
*******************************************************************************/
UINT8 CtrlGetConfigDescr( void )
{
    UINT8   s,len;
    CopySetupReqPkg( SetupGetCfgDescr );
    s = HostCtrlTransfer( Com_Buffer, (PUINT8)&len );                                      // ִпƴ
    if ( s != ERR_SUCCESS )
    {
        return( s );
    }

    len = ( (PXUSB_CFG_DESCR)Com_Buffer ) -> wTotalLengthL;
    CopySetupReqPkg( SetupGetCfgDescr );
    if(HubLowSpeed)                                                                //HUBµ豸
    {
      pSetupReq -> wLengthH = len;                                                 // ܳ
    }
    if(HubLowSpeed == 0)                                                          
    {
      pSetupReq -> wLengthL = len;                                                 // ܳ
    }
    s = HostCtrlTransfer( Com_Buffer, (PUINT8)&len );                                // ִпƴ
    if ( s != ERR_SUCCESS )
    {
        return( s );
    }
#ifdef DISK_BASE_BUF_LEN
	if(len>64) len = 64;
	for(s=0;s!=len;s++)                                                             //U̲ʱҪTxBuffer
		TxBuffer[s]=Com_Buffer[s];                                       
#endif
    return( ERR_SUCCESS );
}
/*******************************************************************************
* Function Name  : CtrlSetUsbAddress
* Description    : USB豸ַ
* Input          : UINT8 addr 豸ַ
* Output         : None
* Return         : ERR_SUCCESS      ɹ
                   
*******************************************************************************/
UINT8 CtrlSetUsbAddress( UINT8 addr ) 
{
    UINT8   s;
    CopySetupReqPkg( SetupSetUsbAddr );
    if(HubLowSpeed)                                                               //HUBµ豸
    {		
      pSetupReq -> wValueH = addr;                                                // USB豸ַ
    }
    if(HubLowSpeed == 0)                                                          
    {		
      pSetupReq -> wValueL = addr;                                                // USB豸ַ
    }		
    s = HostCtrlTransfer( NULL, (PUINT8)NULL );                                         // ִпƴ
    if ( s != ERR_SUCCESS )
    {
        return( s );
    }
    SetHostUsbAddr( addr );                                                     // USBǰUSB豸ַ
    mDelaymS( 10 );                                                             // ȴUSB豸ɲ
    return( ERR_SUCCESS );
}
/*******************************************************************************
* Function Name  : CtrlSetUsbConfig
* Description    : USB豸
* Input          : UINT8 cfg       ֵ
* Output         : None
* Return         : ERR_SUCCESS      ɹ
                   
*******************************************************************************/
UINT8   CtrlSetUsbConfig( UINT8 cfg )                   
{
    CopySetupReqPkg( SetupSetUsbConfig );
    if(HubLowSpeed)                                                               //HUBµ豸
    {		
      pSetupReq -> wValueH = cfg;                                                // USB豸
    }
    if(HubLowSpeed == 0)                                                          
    {		
      pSetupReq -> wValueL = cfg;                                                // USB豸
    }		
    return( HostCtrlTransfer( NULL, (PUINT8)NULL ) );                                  // ִпƴ
}
/*******************************************************************************
* Function Name  : CtrlClearEndpStall
* Description    : ˵STALL
* Input          : UINT8 endp       ˵ַ
* Output         : None
* Return         : ERR_SUCCESS      ɹ
                   
*******************************************************************************/
UINT8   CtrlClearEndpStall( UINT8 endp )  
{
    CopySetupReqPkg( SetupClrEndpStall );                                      // ˵Ĵ
    if(HubLowSpeed)                                                               //HUBµ豸
    {		
      pSetupReq -> wIndexH = endp;                                               // ˵ַ
    }
    if(HubLowSpeed == 0)                                                          
    {		
      pSetupReq -> wIndexL = endp;                                               // ˵ַ
    }	
    return( HostCtrlTransfer( NULL, (PUINT8)NULL ) );                                  // ִпƴ
}

#ifndef DISK_BASE_BUF_LEN
/*******************************************************************************
* Function Name  : CtrlSetUsbIntercace
* Description    : USB豸ӿ
* Input          : UINT8 cfg       ֵ
* Output         : None
* Return         : ERR_SUCCESS      ɹ
                   
*******************************************************************************/
UINT8   CtrlSetUsbIntercace( UINT8 cfg )                   
{
    CopySetupReqPkg( SetupSetUsbInterface );
    if(HubLowSpeed)                                                               //HUBµ豸
    {		
      pSetupReq -> wValueH = cfg;                                                 // USB豸
    }
    if(HubLowSpeed == 0)                                                          
    {		
      pSetupReq -> wValueL = cfg;                                                 // USB豸
    }		
    return( HostCtrlTransfer( NULL, (PUINT8)NULL ) );                             // ִпƴ
}

/*******************************************************************************
* Function Name  : CtrlGetHIDDeviceReport
* Description    : ȡHID豸,TxBuffer
* Input          : None
* Output         : None
* Return         : ERR_SUCCESS ɹ
                           
*******************************************************************************/
UINT8   CtrlGetHIDDeviceReport( UINT8 infc )  
{
    UINT8   s;
    UINT8   len;

	CopySetupReqPkg( SetupSetHIDIdle );
    if(HubLowSpeed)                                                               //HUBµ豸
    {	
		TxBuffer[5] = infc;
    }
    else                                                         
    {		
		TxBuffer[4] = infc;
    }	
    s = HostCtrlTransfer( Com_Buffer, (PUINT8)&len );                                    // ִпƴ
    if ( s != ERR_SUCCESS )
    {
        return( s );
    }	
	
	CopySetupReqPkg( SetupGetHIDDevReport );
    if(HubLowSpeed)                                                               //HUBµ豸
    {	
		TxBuffer[5] = infc;
    }
    else                                                        
    {		
		TxBuffer[4] = infc;
    }	
    s = HostCtrlTransfer( Com_Buffer, (PUINT8)&len );                                    // ִпƴ
    if ( s != ERR_SUCCESS )
    {
        return( s );
    }
	
    return( ERR_SUCCESS );
}
/*******************************************************************************
* Function Name  : CtrlGetHubDescr
* Description    : ȡHUB,TxBuffer
* Input          : None
* Output         : None
* Return         : ERR_SUCCESS ɹ
                   ERR_USB_BUF_OVER ȴ
*******************************************************************************/
UINT8   CtrlGetHubDescr( void )  
{
    UINT8   s;
    UINT8D  len;
    CopySetupReqPkg( SetupGetHubDescr );
    s = HostCtrlTransfer( Com_Buffer, (PUINT8)&len );                                    // ִпƴ
    if ( s != ERR_SUCCESS )
    {
        return( s );
    }
    if ( len < ( (PUSB_SETUP_REQ)SetupGetHubDescr ) -> wLengthL )
    {
        return( ERR_USB_BUF_OVER );                                            // ȴ
    }
//  if ( len < 4 ) return( ERR_USB_BUF_OVER );                                 // ȴ
    return( ERR_SUCCESS );
}
/*******************************************************************************
* Function Name  : HubGetPortStatus
* Description    : ѯHUB˿״̬,TxBuffer
* Input          : UINT8 HubPortIndex 
* Output         : None
* Return         : ERR_SUCCESS ɹ
                   ERR_USB_BUF_OVER ȴ
*******************************************************************************/
UINT8   HubGetPortStatus( UINT8 HubPortIndex )   
{
    UINT8   s;
    UINT8  len;
    pSetupReq -> bRequestType = HUB_GET_PORT_STATUS;
    pSetupReq -> bRequest = HUB_GET_STATUS;
    pSetupReq -> wValueL = 0x00;
    pSetupReq -> wValueH = 0x00;
    pSetupReq -> wIndexL = HubPortIndex;
    pSetupReq -> wIndexH = 0x00;
    pSetupReq -> wLengthL = 0x04;
    pSetupReq -> wLengthH = 0x00;
    s = HostCtrlTransfer( Com_Buffer, (PUINT8)&len );                           // ִпƴ
    if ( s != ERR_SUCCESS )
    {
        return( s );
    }
    if ( len < 4 )
    {
        return( ERR_USB_BUF_OVER );                                            // ȴ
    }
    return( ERR_SUCCESS );
}
/*******************************************************************************
* Function Name  : HubSetPortFeature
* Description    : HUB˿
* Input          : UINT8 HubPortIndex    //HUB˿
                   UINT8 FeatureSelt     //HUB˿
* Output         : None
* Return         : ERR_SUCCESS ɹ
                           
*******************************************************************************/
UINT8   HubSetPortFeature( UINT8 HubPortIndex, UINT8 FeatureSelt ) 
{
    pSetupReq -> bRequestType = HUB_SET_PORT_FEATURE;
    pSetupReq -> bRequest = HUB_SET_FEATURE;
    pSetupReq -> wValueL = FeatureSelt;
    pSetupReq -> wValueH = 0x00;
    pSetupReq -> wIndexL = HubPortIndex;
    pSetupReq -> wIndexH = 0x00;
    pSetupReq -> wLengthL = 0x00;
    pSetupReq -> wLengthH = 0x00;
    return( HostCtrlTransfer( NULL, NULL ) );                                 // ִпƴ
}
/*******************************************************************************
* Function Name  : HubClearPortFeature
* Description    : HUB˿
* Input          : UINT8 HubPortIndex                                         //HUB˿
                   UINT8 FeatureSelt                                          //HUB˿
* Output         : None
* Return         : ERR_SUCCESS ɹ
                           
*******************************************************************************/
UINT8   HubClearPortFeature( UINT8 HubPortIndex, UINT8 FeatureSelt ) 
{
    pSetupReq -> bRequestType = HUB_CLEAR_PORT_FEATURE;
    pSetupReq -> bRequest = HUB_CLEAR_FEATURE;
    pSetupReq -> wValueL = FeatureSelt;
    pSetupReq -> wValueH = 0x00;
    pSetupReq -> wIndexL = HubPortIndex;
    pSetupReq -> wIndexH = 0x00;
    pSetupReq -> wLengthL = 0x00;
    pSetupReq -> wLengthH = 0x00;
    return( HostCtrlTransfer( NULL, NULL ) );                                // ִпƴ
}
/*******************************************************************************
* Function Name  : CtrlGetXPrinterReport1
* Description    : ӡ
* Input          : None
* Output         : None
* Return         : ERR_USB_BUF_OVER ȴ
                   ERR_SUCCESS      ɹ
                   
*******************************************************************************/
UINT8   CtrlGetXPrinterReport1( void )  
{
    UINT8   s;
    UINT16   len;
    CopySetupReqPkg( XPrinterReport );
    s = HostCtrlTransfer( Com_Buffer, (PUINT8)&len );                         // ִпƴ
    if ( s != ERR_SUCCESS )
    {
        return( s );
    }
//     if ( len < ( (XPrinterReport[7]<<8)|(XPrinterReport[6]) ))
//     {
//         return( ERR_USB_BUF_OVER );                                         // ȴ
//     }
    return( ERR_SUCCESS );
}

/*******************************************************************************
* Function Name  : AnalyzeHidIntEndp
* Description    : зHIDж϶˵ĵַ,HubPortIndex0浽ROOTHUBǷֵ򱣴浽HUB½ṹ
* Input          : PUINT8X buf  ݻַ HubPortIndex0ʾHUB0ʾⲿHUBµĶ˿ں
* Output         : None
* Return         : ˵
*******************************************************************************/
UINT8   AnalyzeHidIntEndp( PUINT8X buf, UINT8 HubPortIndex ) 
{
    UINT8   i, s, l;
    s = 0;
	
	if(HubPortIndex)
		memset( DevOnHubPort[HubPortIndex-1].GpVar,0,sizeof(DevOnHubPort[HubPortIndex-1].GpVar) ); //
	else
		memset( ThisUsbDev.GpVar,0,sizeof(ThisUsbDev.GpVar) );                     //
	
    for ( i = 0; i < ( (PXUSB_CFG_DESCR)buf ) -> wTotalLengthL; i += l )       // ж϶˵,ͽӿ
    {
        if ( ( (PXUSB_ENDP_DESCR)(buf+i) ) -> bDescriptorType == USB_DESCR_TYP_ENDP  // Ƕ˵
                && ( ( (PXUSB_ENDP_DESCR)(buf+i) ) -> bmAttributes & USB_ENDP_TYPE_MASK ) == USB_ENDP_TYPE_INTER// ж϶˵
                && ( ( (PXUSB_ENDP_DESCR)(buf+i) ) -> bEndpointAddress & USB_ENDP_DIR_MASK ) )// IN˵
        {           // ж϶˵ĵַ,λ7ͬ־λ,0
            if(HubPortIndex)
				DevOnHubPort[HubPortIndex-1].GpVar[s] = ( (PXUSB_ENDP_DESCR)(buf+i) ) -> bEndpointAddress & USB_ENDP_ADDR_MASK;
			else
				ThisUsbDev.GpVar[s] = ( (PXUSB_ENDP_DESCR)(buf+i) ) -> bEndpointAddress & USB_ENDP_ADDR_MASK;// ж϶˵ĵַԸҪwMaxPacketSizebInterval                                                          
#if DE_PRINTF			
			printf("%02x ",(UINT16)ThisUsbDev.GpVar[s]);
#endif
			s++;
			if(s >= 4) break;	//ֻ4˵
			
		}
        l = ( (PXUSB_ENDP_DESCR)(buf+i) ) -> bLength;                          // ǰ,
        if ( l > 16 )
        {
            break;
        }
    }
#if DE_PRINTF
	printf("\n");
#endif	
    return( s );
}

/*******************************************************************************
* Function Name  : AnalyzeBulkEndp
* Description    : ˵,GpVar[0]GpVar[1]ϴ˵㡣GpVar[2]GpVar[3]´˵
* Input          : bufݻַ   HubPortIndex0ʾHUB0ʾⲿHUBµĶ˿ں
* Output         : None
* Return         : 0
*******************************************************************************/
UINT8   AnalyzeBulkEndp( PUINT8X buf, UINT8 HubPortIndex ) 
{
    UINT8   i, s1,s2, l;
    s1 = 0;s2 = 2;
	
	if(HubPortIndex)
		memset( DevOnHubPort[HubPortIndex-1].GpVar,0,sizeof(DevOnHubPort[HubPortIndex-1].GpVar) ); //
	else
		memset( ThisUsbDev.GpVar,0,sizeof(ThisUsbDev.GpVar) );                     //
	
    for ( i = 0; i < ( (PXUSB_CFG_DESCR)buf ) -> wTotalLengthL; i += l )       // ж϶˵,ͽӿ
    {
        if ( (( (PXUSB_ENDP_DESCR)(buf+i) ) -> bDescriptorType == USB_DESCR_TYP_ENDP)     // Ƕ˵
                && ((( (PXUSB_ENDP_DESCR)(buf+i) ) -> bmAttributes & USB_ENDP_TYPE_MASK ) == USB_ENDP_TYPE_BULK))  // ж϶˵

        {
            if(HubPortIndex)
			{
				if(( (PXUSB_ENDP_DESCR)(buf+i) ) -> bEndpointAddress & USB_ENDP_DIR_MASK )
					DevOnHubPort[HubPortIndex-1].GpVar[s1++] = ( (PXUSB_ENDP_DESCR)(buf+i) ) -> bEndpointAddress & USB_ENDP_ADDR_MASK;
				else
					DevOnHubPort[HubPortIndex-1].GpVar[s2++] = ( (PXUSB_ENDP_DESCR)(buf+i) ) -> bEndpointAddress & USB_ENDP_ADDR_MASK;
			}
			else
			{
				if(( (PXUSB_ENDP_DESCR)(buf+i) ) -> bEndpointAddress & USB_ENDP_DIR_MASK )
					ThisUsbDev.GpVar[s1++] = ( (PXUSB_ENDP_DESCR)(buf+i) ) -> bEndpointAddress & USB_ENDP_ADDR_MASK;
				else
					ThisUsbDev.GpVar[s2++] = ( (PXUSB_ENDP_DESCR)(buf+i) ) -> bEndpointAddress & USB_ENDP_ADDR_MASK;
			}
			
			if(s1 == 2) s1 = 1;
			if(s2 == 4) s2 = 3;			
		}
        l = ( (PXUSB_ENDP_DESCR)(buf+i) ) -> bLength;                          // ǰ,
        if ( l > 16 )
        {
            break;
        }
    }
    return( 0 );
}

//AOAģʽ
UINT8 TouchStartAOA(void)
{
	UINT8 len,s,i,Num;
	UINT16 cp_len;
    //ȡЭ汾
    CopySetupReqPkg( GetProtocol );
    s = HostCtrlTransfer( Com_Buffer, &len );  // ִпƴ
    if ( s != ERR_SUCCESS )
    {
        return( s );
    }
	if(Com_Buffer[0]<2) return  ERR_AOA_PROTOCOL;

    //ַ
    for(i=0; i<6; i++)
    {
        Num=Sendlen[i];
        CopySetupReqPkg(&SetStringID[8*i]);
		cp_len = (pSetupReq -> wLengthH << 8)|( pSetupReq -> wLengthL);
		memcpy(Com_Buffer,&StringID[Num],cp_len);
        s = HostCtrlTransfer( Com_Buffer, &len );  // ִпƴ
        if ( s != ERR_SUCCESS )
        {
            return( s );
        }
    }	

    CopySetupReqPkg(TouchAOAMode);
    s = HostCtrlTransfer( Com_Buffer, &len );  // ִпƴ
    if ( s != ERR_SUCCESS )
    {
        return( s );
    }
    return ERR_SUCCESS;	
}

/*******************************************************************************
* Function Name  : InitRootDevice
* Description    : ʼָROOT-HUB˿ڵUSB豸
* Input          : UINT8 RootHubIndex ָ˿ڣHUB˿ں0/1
* Output         : None
* Return         :
*******************************************************************************/
UINT8 InitRootDevice( void ) 
{
    UINT8   t,i, s, cfg, dv_cls, if_cls,ifc;
	UINT8 touchaoatm = 0;
    t = 0;
#if DE_PRINTF	
    printf( "Reset USB Port\n");
#endif
USBDevEnum:
    for(i=0;i<t;i++)
    {
        mDelaymS( 100 );	
        if(t>10) return( s );			
    }
    ResetRootHubPort( );                                                    // ⵽豸,λӦ˿ڵUSB
    for ( i = 0, s = 0; i < 100; i ++ )                                     // ȴUSB豸λ,100mSʱ
    {
        mDelaymS( 1 );
        if ( EnableRootHubPort( ) == ERR_SUCCESS )                          // ʹROOT-HUB˿
        {
            i = 0;
            s ++;                                                           // ʱȴUSB豸Ӻȶ
            if ( s > (20+t) )
            {
                break;                                                      // Ѿȶ15mS
            }
        }
    }	
    if ( i )                                                                 // λ豸û
    {
        DisableRootHubPort( );
#if DE_PRINTF
        printf( "Disable usb port because of disconnect\n" );
#endif	
//         return( ERR_USB_DISCON );
    }
    SelectHubPort( 0 );
#if DE_PRINTF		
    printf( "GetDevDescr: " );
#endif
    s = CtrlGetDeviceDescr( );                                               // ȡ豸
    if ( s == ERR_SUCCESS )
    {
#if DE_PRINTF	
        for ( i = 0; i < ( (PUSB_SETUP_REQ)SetupGetDevDescr ) -> wLengthL; i ++ )
        {
            printf( "x%02X ", (UINT16)( Com_Buffer[i] ) );				
        }
        printf( "\n" );                                                       // ʾ
#endif	
		ThisUsbDev.DeviceVID = (((UINT16)((PXUSB_DEV_DESCR)Com_Buffer)->idVendorH)<<8 ) + ((PXUSB_DEV_DESCR)Com_Buffer)->idVendorL; //VID PIDϢ
		ThisUsbDev.DevicePID = (((UINT16)((PXUSB_DEV_DESCR)Com_Buffer)->idProductH)<<8 ) + ((PXUSB_DEV_DESCR)Com_Buffer)->idProductL;
        dv_cls = ( (PXUSB_DEV_DESCR)Com_Buffer ) -> bDeviceClass;               // 豸			
        s = CtrlSetUsbAddress( ( (PUSB_SETUP_REQ)SetupSetUsbAddr ) -> wValueL );// USB豸ַ,RootHubIndexԱ֤2HUB˿ڷ䲻ͬĵַ
        if ( s == ERR_SUCCESS )
        {
            ThisUsbDev.DeviceAddress = ( (PUSB_SETUP_REQ)SetupSetUsbAddr ) -> wValueL;  // USBַ
#if DE_PRINTF						
            printf( "GetCfgDescr: " );
#endif					
            s = CtrlGetConfigDescr( );                                        // ȡ
            if ( s == ERR_SUCCESS )
            {
                cfg = ( (PXUSB_CFG_DESCR)Com_Buffer ) -> bConfigurationValue;
                ifc = ( (PXUSB_CFG_DESCR)Com_Buffer ) -> bNumInterfaces;					
#if DE_PRINTF							
                for ( i = 0; i < ( (PXUSB_CFG_DESCR)Com_Buffer ) -> wTotalLengthL; i ++ )
                {
                    printf( "x%02X ", (UINT16)( Com_Buffer[i] ) );
                }
                printf("\n");
#endif								
                                                                              //,ȡ˵/˵ַ/˵С,±endp_addrendp_size
                if_cls = ( (PXUSB_CFG_DESCR_LONG)Com_Buffer ) -> itf_descr.bInterfaceClass;  // ӿ								
                if ( dv_cls == 0x00 && if_cls == USB_DEV_CLASS_STORAGE )      // USB洢豸,ȷU
                {
					AnalyzeBulkEndp(Com_Buffer , 0 );
#if DE_PRINTF
					for(i=0;i!=4;i++)
					{
						printf("%02x ",(UINT16)ThisUsbDev.GpVar[i] );
					}
					printf("\n");
#endif					
                    s = CtrlSetUsbConfig( cfg );                              // USB豸
                    if ( s == ERR_SUCCESS )
                    {
                        ThisUsbDev.DeviceStatus = ROOT_DEV_SUCCESS;
                        ThisUsbDev.DeviceType = USB_DEV_CLASS_STORAGE;
#if DE_PRINTF												
                        printf( "USB-Disk Ready\n" );
#endif											
                        SetUsbSpeed( 1 );                                     // ĬΪȫ
                        return( ERR_SUCCESS );
                    }
                }
                else if ( dv_cls == 0x00 && if_cls == USB_DEV_CLASS_PRINTER && ( (PXUSB_CFG_DESCR_LONG)Com_Buffer ) -> itf_descr.bInterfaceSubClass == 0x01 )// Ǵӡ豸
                {
#if DE_PRINTF										
                    printf( "USB-Print OK\n" );
#endif									
                    if((Com_Buffer[19] == 5)&&(Com_Buffer[20]&&0x80)){
                       ThisUsbDev.GpVar[0] = Com_Buffer[20];                     //IN ˵											
                    }
                    else if((Com_Buffer[19] == 5)&&((Com_Buffer[20]&&0x80) == 0)){
                       ThisUsbDev.GpVar[1] = Com_Buffer[20];                    //OUT ˵												
                    }		
                    if((Com_Buffer[26] == 5)&&(Com_Buffer[20]&&0x80)){
                       ThisUsbDev.GpVar[0] = Com_Buffer[27];                     //IN ˵											
                    }
                    else if((Com_Buffer[26] == 5)&&((Com_Buffer[20]&&0x80) == 0)){
                       ThisUsbDev.GpVar[1] = Com_Buffer[27];                    //OUT ˵												
                    }										
//                  ThisUsbDev.GpVar = ( (PUSB_CFG_DESCR_LONG)Com_Buffer ) -> endp_descr[0].bEndpointAddress;// ˵
                    s = CtrlSetUsbConfig( cfg );                            // USB豸
                    if ( s == ERR_SUCCESS )
                    {									
                        s = CtrlSetUsbIntercace(cfg);
//                         if(s == ERR_SUCCESS){
                                                                           //豣˵ϢԱUSB
                         s = CtrlGetXPrinterReport1( );                    //ӡ
                         if(s == ERR_SUCCESS){													 
                           ThisUsbDev.DeviceStatus = ROOT_DEV_SUCCESS;
                           ThisUsbDev.DeviceType = USB_DEV_CLASS_PRINTER;
#if DE_PRINTF														 
                           printf( "USB-Print Ready\n" );
#endif													 
                           SetUsbSpeed( 1 );                               // ĬΪȫ
                           return( ERR_SUCCESS );
						 }													 
//                         }
                    }
                }
                else if ( (dv_cls == 0x00) && (if_cls == USB_DEV_CLASS_HID) && (( (PXUSB_CFG_DESCR_LONG)Com_Buffer ) -> itf_descr.bInterfaceSubClass <= 0x01) )// HID豸,/
                { 									
                    s = AnalyzeHidIntEndp( Com_Buffer,0 );                    // зHIDж϶˵ĵַ								
#if DE_PRINTF														 
                    printf( "AnalyzeHidIntEndp %02x\n",(UINT16)s );
#endif		                    
					if_cls = ( (PXUSB_CFG_DESCR_LONG)Com_Buffer ) -> itf_descr.bInterfaceProtocol;
#if DE_PRINTF														 
                    printf( "CtrlSetUsbConfig %02x\n",(UINT16)cfg );
#endif		
                    s = CtrlSetUsbConfig( cfg );                          // USB豸								
                    if ( s == ERR_SUCCESS )
                    {
#if DE_PRINTF												
                        printf( "GetHIDReport: " );
#endif			
                        for(dv_cls=0;dv_cls<ifc;dv_cls++)
                        {											
							s = CtrlGetHIDDeviceReport(dv_cls);                    //ȡ
							if(s == ERR_SUCCESS)
							{
#if DE_PRINTF														
								for ( i = 0; i < 64; i++ )
								{
									printf( "x%02X ", (UINT16)( Com_Buffer[i] ) );
								}
								printf("\n");
#endif														
							}
						}
                        //Set_Idle( );
                                                                         //豣˵ϢԱUSB
                        ThisUsbDev.DeviceStatus = ROOT_DEV_SUCCESS;
                        if ( if_cls == 1 )
                        {
                            ThisUsbDev.DeviceType = DEV_TYPE_KEYBOARD;
                                                                         //һʼ,豸ָʾLED
                            if(ifc > 1)
                            {
#if DE_PRINTF														
								printf( "USB_DEV_CLASS_HID Ready\n" );
#endif																
								ThisUsbDev.DeviceType = USB_DEV_CLASS_HID;//HID豸															
                            }																												
#if DE_PRINTF														
                            printf( "USB-Keyboard Ready\n" );
#endif													
                            SetUsbSpeed( 1 );                            // ĬΪȫ

                            return( ERR_SUCCESS );
                        }
                        else if ( if_cls == 2 )
                        {
                            ThisUsbDev.DeviceType = DEV_TYPE_MOUSE;
                                                                         //ΪԺѯ״̬,Ӧ÷,ȡж϶˿ڵĵַ,ȵϢ
                            if(ifc > 1)
                            {
#if DE_PRINTF														
								printf( "USB_DEV_CLASS_HID Ready\n" );
#endif																
								ThisUsbDev.DeviceType = USB_DEV_CLASS_HID;//HID豸															
                            }															
#if DE_PRINTF													
                            printf( "USB-Mouse Ready\n" );
#endif													
                            SetUsbSpeed( 1 );                            // ĬΪȫ
																											
                            return( ERR_SUCCESS );
                        }
                        s = ERR_USB_UNSUPPORT;
                    }
                }
                else if ( dv_cls == USB_DEV_CLASS_HUB )                   // HUB豸,
                {
                    s = AnalyzeHidIntEndp( Com_Buffer,0 );                    // зHIDж϶˵ĵַ
#if DE_PRINTF		
                    printf( "AnalyzeHidIntEndp %02x\n",(UINT16)s );
#endif	                   			
#if DE_PRINTF										
                    printf( "GetHubDescr: ");
#endif									
                    s = CtrlGetHubDescr( );
                    if ( s == ERR_SUCCESS )
                    {
#if DE_PRINTF												
                        for( i = 0; i < Com_Buffer[0]; i++ )
                        {
                            printf( "x%02X ",(UINT16)(Com_Buffer[i]) );
                        }                       
						printf("\n");
#endif												
                        ThisUsbDev.GpHUBPortNum = ( (PXUSB_HUB_DESCR)Com_Buffer ) -> bNbrPorts;// HUBĶ˿
                        if ( ThisUsbDev.GpHUBPortNum > HUB_MAX_PORTS )
                        {
                            ThisUsbDev.GpHUBPortNum = HUB_MAX_PORTS;// ΪṹDevOnHubPortʱΪٶÿHUBHUB_MAX_PORTS˿
                        }
                        //if ( ( (PXUSB_HUB_DESCR)Com_Buffer ) -> wHubCharacteristics[0] & 0x04 ) printf("мĸ豸\n");
                        //else printf("һļƷ\n");
                        s = CtrlSetUsbConfig( cfg );                     // USB豸
                        if ( s == ERR_SUCCESS )
                        {
                            ThisUsbDev.DeviceStatus = ROOT_DEV_SUCCESS;
                            ThisUsbDev.DeviceType = USB_DEV_CLASS_HUB;
                            //豣˵ϢԱUSB,ж϶˵HUB¼֪ͨ,ʹòѯ״̬ƴ
                            //HUB˿ϵ,ѯ˿״̬,ʼ豸ӵHUB˿,ʼ豸
                            for ( i = 1; i <= ThisUsbDev.GpHUBPortNum; i ++ )// HUB˿ڶϵ
                            {
                                DevOnHubPort[i-1].DeviceStatus = ROOT_DEV_DISCONNECT;  // ⲿHUB˿豸״̬
                                s = HubSetPortFeature( i, HUB_PORT_POWER );
                                if ( s != ERR_SUCCESS )
                                {
#if DE_PRINTF																		
                                    printf( "Ext-HUB Port_%1d# power on error\n",(UINT16)i );// ˿ϵʧ
#endif																	
                                }
                            }
//							for ( i = 1; i <= ThisUsbDev.GpVar[0]; i ++ )            // ѯHUB˿״̬
//							{
//								s = HubGetPortStatus( i );                           // ȡ˿״̬
//								if ( s != ERR_SUCCESS ) 
//#if DE_PRINTF																	
//								printf( "Ext-HUB Port_%1d#	clear connection error\n",(UINT16)i );	// ˿״̬ʧ
//#endif															
//							}														
                            SetUsbSpeed( 1 );                                        // ĬΪȫ
                            return( ERR_SUCCESS );
                        }
                    }
                }
                else                                                                 //豸
                {			
#if DE_PRINTF														 
                    printf( "dv_cls %02x\n",(UINT16)dv_cls );
                    printf( "if_cls %02x\n",(UINT16)if_cls );
                    printf( "if_subcls %02x\n",(UINT16)( (PXUSB_CFG_DESCR_LONG)Com_Buffer ) -> itf_descr.bInterfaceSubClass );									
#endif				
					AnalyzeBulkEndp(Com_Buffer , 0 );                                  //˵
#if DE_PRINTF
					for(i=0;i!=4;i++)
					{
						printf("%02x ",(UINT16)ThisUsbDev.GpVar[i] );
					}
					printf("\n");
#endif
                    s = CtrlSetUsbConfig( cfg );                                     // USB豸
                    if ( s == ERR_SUCCESS ) 
                    {
#if DE_PRINTF						
						printf("%02x %02x\n",(UINT16)ThisUsbDev.DeviceVID,(UINT16)ThisUsbDev.DevicePID);
#endif						
						if((ThisUsbDev.DeviceVID==0x18D1)&&(ThisUsbDev.DevicePID&0xff00)==0x2D00)   //AOA
						{
							printf("AOA Mode\n");
							ThisUsbDev.DeviceStatus = ROOT_DEV_SUCCESS;
							ThisUsbDev.DeviceType = DEF_AOA_DEVICE;                      //ֻԶı࣬USBЭ
							SetUsbSpeed( 1 );                                            // ĬΪȫ
							return( ERR_SUCCESS );
						}
						else   //AOA ģʽģʽ.
						{
							s = TouchStartAOA();
							if( s == ERR_SUCCESS ) 
							{
								if(touchaoatm<3)         //AOA
								{
									touchaoatm++;
									mDelaymS(500);      //ְ׿豸ԶϿԴ˴ʱ
									goto USBDevEnum;    //ʵԲתAOAЭ涨豸Զ½ߡ
								}
								//ִе⣬˵֧ܲAOA豸
								ThisUsbDev.DeviceType = dv_cls ? dv_cls : if_cls;
								ThisUsbDev.DeviceStatus = ROOT_DEV_SUCCESS;
								SetUsbSpeed( 1 );                                            // ĬΪȫ
								return( ERR_SUCCESS );                                       // δ֪豸ʼɹ									
							}							
						}
                    }
                }
            }
        }
    }
#if DE_PRINTF			
    printf( "InitRootDev Err = %02X\n", (UINT16)s );
#endif		
    ThisUsbDev.DeviceStatus = ROOT_DEV_FAILED;
    SetUsbSpeed( 1 );                                                                 // ĬΪȫ
    t++;
    goto USBDevEnum;		
}
/*******************************************************************************
* Function Name  : EnumAllRootDevice
* Description    : öROOT-HUB˿ڵUSB豸
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
UINT8   EnumAllRootDevice( void )   
{
    UINT8I   s;
#if DE_PRINTF	
    printf( "EnumUSBDev\n" );
#endif
	if ( ThisUsbDev.DeviceStatus == ROOT_DEV_CONNECTED )                        // ղ豸δʼ
	{
		s = InitRootDevice( );                                      // ʼ/öָHUB˿ڵUSB豸
		if ( s != ERR_SUCCESS )
		{
			return( s );
		}
	}
    return( ERR_SUCCESS );
}
/*******************************************************************************
* Function Name  : InitDevOnHub
* Description    : ʼöⲿHUBĶUSB豸
* Input          : UINT8 HubPortIndex  ָⲿHUB
* Output         : None
* Return         : ERR_SUCCESS ɹ
                   ERR_USB_UNKNOWN δ֪豸                 
*******************************************************************************/
UINT8 InitDevOnHub( UINT8 HubPortIndex ) 
{
    UINT8   i, s, cfg, dv_cls, if_cls;
    UINT8   ifc;
#if DE_PRINTF		
    printf( "Init dev @ExtHub-port_%1d ", (UINT16)HubPortIndex );
#endif
    if ( HubPortIndex == 0 )
    {
        return( ERR_USB_UNKNOWN );
    }
    SelectHubPort( HubPortIndex );                                      // ѡָROOT-HUB˿ڵⲿHUBָ˿,ѡٶ
#if DE_PRINTF		
    printf( "GetDevDescr: " );
#endif
    s = CtrlGetDeviceDescr( );                                          // ȡ豸
    if ( s != ERR_SUCCESS )
    {
        return( s );
    }
	DevOnHubPort[HubPortIndex-1].DeviceVID = (((UINT16)((PXUSB_DEV_DESCR)Com_Buffer)->idVendorH)<<8 ) + ((PXUSB_DEV_DESCR)Com_Buffer)->idVendorL; //VID PIDϢ
	DevOnHubPort[HubPortIndex-1].DevicePID = (((UINT16)((PXUSB_DEV_DESCR)Com_Buffer)->idProductH)<<8 ) + ((PXUSB_DEV_DESCR)Com_Buffer)->idProductL;
	
    dv_cls = ( (PXUSB_DEV_DESCR)Com_Buffer ) -> bDeviceClass;             // 豸
    cfg = ( 1<<4 ) + HubPortIndex;                                      // һUSBַ,ַص
    s = CtrlSetUsbAddress( cfg );                                       // USB豸ַ
    if ( s != ERR_SUCCESS )
    {
        return( s );
    }
    DevOnHubPort[HubPortIndex-1].DeviceAddress = cfg;                   // USBַ
#if DE_PRINTF			
    printf( "GetCfgDescr: " );
#endif
    s = CtrlGetConfigDescr( );                                          // ȡ
    if ( s != ERR_SUCCESS )
    {
        return( s );
    }
    cfg = ( (PXUSB_CFG_DESCR)Com_Buffer ) -> bConfigurationValue;
#if DE_PRINTF			
    for ( i = 0; i < ( (PXUSB_CFG_DESCR)Com_Buffer ) -> wTotalLengthL; i ++ )
    {
        printf( "x%02X ", (UINT16)( Com_Buffer[i] ) );
    }
    printf("\n");
#endif		
    /* ,ȡ˵/˵ַ/˵С,±endp_addrendp_size */
    if_cls = ( (PXUSB_CFG_DESCR_LONG)Com_Buffer ) -> itf_descr.bInterfaceClass; // ӿ
    if ( dv_cls == 0x00 && if_cls == USB_DEV_CLASS_STORAGE )                  // USB洢豸,ȷU
    {
		AnalyzeBulkEndp(Com_Buffer , HubPortIndex );
#if DE_PRINTF
		for(i=0;i!=4;i++)
		{
			printf("%02x ",(UINT16)DevOnHubPort[HubPortIndex-1].GpVar[i] );
		}
		printf("\n");
#endif
        s = CtrlSetUsbConfig( cfg );                                          // USB豸
        if ( s == ERR_SUCCESS )
        {
            DevOnHubPort[HubPortIndex-1].DeviceStatus = ROOT_DEV_SUCCESS;
            DevOnHubPort[HubPortIndex-1].DeviceType = USB_DEV_CLASS_STORAGE;
#if DE_PRINTF						
            printf( "USB-Disk Ready\n" );
#endif					
            SetUsbSpeed( 1 );                                                 // ĬΪȫ
            return( ERR_SUCCESS );
        }
    }
    else if ( (dv_cls == 0x00) && (if_cls == USB_DEV_CLASS_HID) && (( (PXUSB_CFG_DESCR_LONG)Com_Buffer ) -> itf_descr.bInterfaceSubClass <= 0x01) )    // HID豸,/
    {
        ifc = ( (PXUSB_CFG_DESCR_LONG)Com_Buffer ) -> cfg_descr.bNumInterfaces;			
        s = AnalyzeHidIntEndp( Com_Buffer, HubPortIndex);                                     // зHIDж϶˵ĵַ
#if DE_PRINTF														 
        printf( "AnalyzeHidIntEndp %02x\n",(UINT16)s );
#endif	
        if_cls = ( (PXUSB_CFG_DESCR_LONG)Com_Buffer ) -> itf_descr.bInterfaceProtocol;
        s = CtrlSetUsbConfig( cfg );                                           // USB豸
        if ( s == ERR_SUCCESS )
        {
			for(dv_cls=0;dv_cls<ifc;dv_cls++)
			{											
				s = CtrlGetHIDDeviceReport(dv_cls);                    //ȡ
				if(s == ERR_SUCCESS)
				{
#if DE_PRINTF														
					for ( i = 0; i < 64; i++ )
					{
						printf( "x%02X ", (UINT16)( Com_Buffer[i] ) );
					}
					printf("\n");
#endif														
				}
			}					
            //豣˵ϢԱUSB
            DevOnHubPort[HubPortIndex-1].DeviceStatus = ROOT_DEV_SUCCESS;
			if ( if_cls == 1 )
			{
				DevOnHubPort[HubPortIndex-1].DeviceType = DEV_TYPE_KEYBOARD;
															 //һʼ,豸ָʾLED
				if(ifc > 1)
				{
#if DE_PRINTF														
					printf( "USB_DEV_CLASS_HID Ready\n" );
#endif																
					DevOnHubPort[HubPortIndex-1].DeviceType = USB_DEV_CLASS_HID;//HID豸															
				}																												
#if DE_PRINTF														
				printf( "USB-Keyboard Ready\n" );
#endif													
				SetUsbSpeed( 1 );                            // ĬΪȫ

				return( ERR_SUCCESS );
			}
			else if ( if_cls == 2 )
			{
				DevOnHubPort[HubPortIndex-1].DeviceType = DEV_TYPE_MOUSE;
															 //ΪԺѯ״̬,Ӧ÷,ȡж϶˿ڵĵַ,ȵϢ
				if(ifc > 1)
				{
#if DE_PRINTF														
					printf( "USB_DEV_CLASS_HID Ready\n" );
#endif																
					DevOnHubPort[HubPortIndex-1].DeviceType = USB_DEV_CLASS_HID;//HID豸															
				}															
#if DE_PRINTF													
				printf( "USB-Mouse Ready\n" );
#endif													
				SetUsbSpeed( 1 );                            // ĬΪȫ
																								
				return( ERR_SUCCESS );
			}
			s = ERR_USB_UNSUPPORT;			
        }
    }
    else if ( dv_cls == USB_DEV_CLASS_HUB )                                     // HUB豸,
    {
        DevOnHubPort[HubPortIndex-1].DeviceType = USB_DEV_CLASS_HUB;
#if DE_PRINTF				
        printf( "This program don't support Level 2 HUB\n");                    // Ҫֶ֧༶HUBοչ
#endif		
        s = HubClearPortFeature( i, HUB_PORT_ENABLE );                          // ֹHUB˿
        if ( s != ERR_SUCCESS )
        {
            return( s );
        }
        s = ERR_USB_UNSUPPORT;
    }
	else                                                                //豸
	{
		AnalyzeBulkEndp(Com_Buffer , HubPortIndex );                      //˵
#if DE_PRINTF
		for(i=0;i!=4;i++)
		{
			printf("%02x ",(UINT16)DevOnHubPort[HubPortIndex-1].GpVar[i] );
		}
		printf("\n");
#endif	
		s = CtrlSetUsbConfig( cfg );                                     // USB豸
		if ( s == ERR_SUCCESS ) 
		{
			//豣˵ϢԱUSB
			DevOnHubPort[HubPortIndex-1].DeviceStatus = ROOT_DEV_SUCCESS;
			DevOnHubPort[HubPortIndex-1].DeviceType = dv_cls ? dv_cls : if_cls;
            SetUsbSpeed( 1 );                                                    // ĬΪȫ
            return( ERR_SUCCESS );                                               //δ֪豸ʼɹ
		}		
	}
#if DE_PRINTF			
    printf( "InitDevOnHub Err = %02X\n", (UINT16)s );
#endif		
    DevOnHubPort[HubPortIndex-1].DeviceStatus = ROOT_DEV_FAILED;
    SetUsbSpeed( 1 );                                                            // ĬΪȫ
    return( s );
}
/*******************************************************************************
* Function Name  : EnumHubPort
* Description    : öָROOT-HUB˿ϵⲿHUBĸ˿,˿ӻƳ¼ʼUSB豸
* Input          : UINT8 RootHubIndex ROOT_HUB0ROOT_HUB1
* Output         : None
* Return         : ERR_SUCCESS ɹ
                           ʧ
*******************************************************************************/
UINT8 EnumHubPort( ) 
{
    UINT8   i, s;

    for ( i = 1; i <= ThisUsbDev.GpHUBPortNum; i ++ )                                       // ѯĶ˿Ƿб仯
    {
        SelectHubPort( 0 );                                                          // ѡָROOT-HUB˿,õǰUSBٶԼ豸USBַ
        s = HubGetPortStatus( i );                                                   // ȡ˿״̬
        if ( s != ERR_SUCCESS )
        {
            return( s );                                                              // ǸHUBϿ
        }
        if ( (( Com_Buffer[0]&(1<<(HUB_PORT_CONNECTION&0x07)) ) && ( Com_Buffer[2]&(1<<(HUB_C_PORT_CONNECTION&0x07)) ))||(Com_Buffer[2] == 0x10) ) 
        {                                                                            // 豸
			DevOnHubPort[i-1].DeviceStatus = ROOT_DEV_CONNECTED;                     // 豸
            DevOnHubPort[i-1].DeviceAddress = 0x00;
            s = HubGetPortStatus( i );                                               // ȡ˿״̬
            if ( s != ERR_SUCCESS )
            {
                return( s );                                                         // ǸHUBϿ
            }
            DevOnHubPort[i-1].DeviceSpeed = Com_Buffer[1] & (1<<(HUB_PORT_LOW_SPEED&0x07)) ? 0 : 1;// ٻȫ
            if ( DevOnHubPort[i-1].DeviceSpeed )
            {
#if DE_PRINTF								
                printf( "Found full speed device on port %1d\n", (UINT16)i );
#endif							
            }
            else
            {
#if DE_PRINTF								
                printf( "Found low speed device on port %1d\n", (UINT16)i );
#endif							
            }
            mDelaymS( 200 );                                                          // ȴ豸ϵȶ
            s = HubSetPortFeature( i, HUB_PORT_RESET );                               // 豸ӵĶ˿ڸλ
            if ( s != ERR_SUCCESS )
            {
                return( s );                                                          // ǸHUBϿ
            }
#if DE_PRINTF							
            printf( "Reset port and then wait in\n" );
#endif						
            do                                                                        // ѯλ˿,ֱλ,ɺ״̬ʾ
            {
                mDelaymS( 1 );
                s = HubGetPortStatus( i );
                if ( s != ERR_SUCCESS )
                {
                    return( s );                                                      // ǸHUBϿ
                }
            }
            while ( Com_Buffer[0] & (1<<(HUB_PORT_RESET&0x07)) );                       // ˿ڸλȴ
            mDelaymS( 100 );
            s = HubClearPortFeature( i, HUB_C_PORT_RESET );                           // λɱ־
//             s = HubSetPortFeature( i, HUB_PORT_ENABLE );                              // HUB˿
            s = HubClearPortFeature( i, HUB_C_PORT_CONNECTION );                      // ӻƳ仯־
            if ( s != ERR_SUCCESS )
            {
                return( s );
            }
            s = HubGetPortStatus( i );                                                // ٶȡ״̬,豸Ƿ
            if ( s != ERR_SUCCESS )
            {
                return( s );
            }
            if ( ( Com_Buffer[0]&(1<<(HUB_PORT_CONNECTION&0x07)) ) == 0 )
            {
                DevOnHubPort[i-1].DeviceStatus = ROOT_DEV_DISCONNECT;                 // 豸
            }
            s = InitDevOnHub( i );                                                    // ʼUSB豸
            if ( s != ERR_SUCCESS )
            {
                return( s );
            }
            SetUsbSpeed( 1 );                                                         // ĬΪȫ
        }
		else if (Com_Buffer[2]&(1<<(HUB_C_PORT_ENABLE&0x07))  )                         // 豸ӳ
		{
			HubClearPortFeature( i, HUB_C_PORT_ENABLE );                              // Ӵ־
#if DE_PRINTF						
			printf( "Device on port error\n" );		
#endif					
			s = HubSetPortFeature( i, HUB_PORT_RESET );                               // 豸ӵĶ˿ڸλ
			if ( s != ERR_SUCCESS ) 
			return( s );                                                              // ǸHUBϿ
			do                                                                        // ѯλ˿,ֱλ,ɺ״̬ʾ
			{
				mDelaymS( 1 );
				s = HubGetPortStatus( i );
				if ( s != ERR_SUCCESS ) return( s );                                    // ǸHUBϿ
			} while ( Com_Buffer[0] & (1<<(HUB_PORT_RESET&0x07)) );                     // ˿ڸλȴ
		}
        else if ( ( Com_Buffer[0]&(1<<(HUB_PORT_CONNECTION&0x07)) ) == 0 )              // 豸ѾϿ
        {
            if ( DevOnHubPort[i-1].DeviceStatus >= ROOT_DEV_CONNECTED )
            {
#if DE_PRINTF								
                printf( "Device on port %1d removed\n", (UINT16)i );
#endif							
            }
            DevOnHubPort[i-1].DeviceStatus = ROOT_DEV_DISCONNECT;                     // 豸
            if ( Com_Buffer[2]&(1<<(HUB_C_PORT_CONNECTION&0x07)) )
            {
                HubClearPortFeature( i, HUB_C_PORT_CONNECTION );                      // Ƴ仯־
            }
        }
    }
    return( ERR_SUCCESS );                                                            // زɹ
}
/*******************************************************************************
* Function Name  : EnumAllHubPort
* Description    : öROOT-HUB˿ⲿHUBĶUSB豸
* Input          : None
* Output         : None
* Return         : ERR_SUCCESS ɹ
                           ʧ
*******************************************************************************/
UINT8   EnumAllHubPort( void ) 
{
    UINT8   s;

	if ( (ThisUsbDev.DeviceStatus >= ROOT_DEV_SUCCESS) && (ThisUsbDev.DeviceType == USB_DEV_CLASS_HUB) )// HUBöٳɹ
	{ 
		SelectHubPort( 0 );                                                        // ѡָROOT-HUB˿,õǰUSBٶԼ豸USBַ
		//ʲô?  HUB˿ϵ,ѯ˿״̬,ʼ豸ӵHUB˿,ʼ豸
//             for ( i = 1; i <= ThisUsbDev.GpVar; i ++ ){                             // ʼHUB˿
//               s = HubSetPortFeature( i, HUB_PORT_POWER );                           // HUB˿ϵ
//               if ( s != ERR_SUCCESS )
//               {
//                 return( s );                                                        // ǸHUBϿ
//               }             							
//             }				
		s = EnumHubPort( );                                                        // öָROOT-HUB˿ϵⲿHUBĸ˿,˿ӻƳ¼
		if ( s != ERR_SUCCESS )                                                    // HUBϿ
		{
#if DE_PRINTF								
			printf( "EnumAllHubPort err = %02X\n", (UINT16)s );
#endif							
		}
		SetUsbSpeed( 1 );                                                          // ĬΪȫ
	}
    return( ERR_SUCCESS );
}
/*******************************************************************************
* Function Name  : SearchTypeDevice
* Description    : ROOT-HUBԼⲿHUB˿ָ͵豸ڵĶ˿ں,˿ںΪ0xFFFFδ
* Input          : UINT8 type 豸
* Output         : None
* Return         : 8λΪROOT-HUB˿ں,8λΪⲿHUBĶ˿ں,8λΪ0豸ֱROOT-HUB˿
                   ȻҲԸUSBĳVIDƷPID(Ҫ¼豸VIDPID),Լָ
*******************************************************************************/
UINT16  SearchTypeDevice( UINT8 type )   
{
	UINT8  RootHubIndex;                                                          //CH554ֻһUSB,RootHubIndex = 0,ֻ迴ֵĵͰλ
    UINT8  HubPortIndex;
	
	RootHubIndex = 0;
	if ( (ThisUsbDev.DeviceType == USB_DEV_CLASS_HUB) && (ThisUsbDev.DeviceStatus >= ROOT_DEV_SUCCESS) )// ⲿHUBöٳɹ
	{
		for ( HubPortIndex = 1; HubPortIndex <= ThisUsbDev.GpHUBPortNum; HubPortIndex ++ )// ⲿHUBĸ˿
		{
			if ( DevOnHubPort[HubPortIndex-1].DeviceType == type && DevOnHubPort[HubPortIndex-1].DeviceStatus >= ROOT_DEV_SUCCESS )
			{
				return( ( (UINT16)RootHubIndex << 8 ) | HubPortIndex );           // ƥöٳɹ
			}
		}
	}
	if ( (ThisUsbDev.DeviceType == type) && (ThisUsbDev.DeviceStatus >= ROOT_DEV_SUCCESS) )
	{
		return( (UINT16)RootHubIndex << 8 );                                      // ƥöٳɹ,ROOT-HUB˿
	} 
	
    return( 0xFFFF );
}
/*******************************************************************************
* Function Name  : SETorOFFNumLock
* Description    : NumLockĵж
* Input          : PUINT8 buf Ƽֵ
* Output         : None
* Return         : None
*******************************************************************************/
UINT8 SETorOFFNumLock(PUINT8 buf)
{
    UINT8 tmp[]= {0x21,0x09,0x00,0x02,0x00,0x00,0x01,0x00};
    UINT8 len,s;
    if((buf[2]==0x53)&(buf[0]|buf[1]|buf[3]|buf[4]|buf[5]|buf[6]|buf[7]==0))
    {			
        if(HubLowSpeed)                                                               //HUBµ豸
        {	
			((PUINT8X)pSetupReq)[ 0 ] = 0X21;					
			for ( s = 1; s != sizeof( tmp )+1; s ++ )
			{
				((PUINT8X)pSetupReq)[ s ] = tmp[s];
			}
        }
        if(HubLowSpeed == 0)                                                          
        {		
			for ( s = 0; s != sizeof( tmp ); s ++ )
			{
				((PUINT8X)pSetupReq)[ s ] = tmp[s];
			}
        }	
        s = HostCtrlTransfer( Com_Buffer, &len );                                     // ִпƴ
        if ( s != ERR_SUCCESS )
        {
            return( s );
        }
    }
    return( ERR_SUCCESS );
}
#endif


#ifdef DISK_BASE_BUF_LEN
UINT8	InitRootDevice( void )                                                       // ʼUSB豸
{
	UINT8	i, s, cfg, dv_cls, if_cls;
#if DE_PRINTF	
	printf( "Reset host port\n" );
#endif
	ResetRootHubPort( );                                                            // ⵽豸,λӦ˿ڵUSB
	for ( i = 0, s = 0; i < 100; i ++ ) {                                           // ȴUSB豸λ,100mSʱ
		mDelaymS( 1 );
		if ( EnableRootHubPort( ) == ERR_SUCCESS ) {                                  // ʹܶ˿
			i = 0;
			s ++;                                                                       // ʱȴUSB豸Ӻȶ
			if ( s > 100 ) break;                                                       // Ѿȶ100mS
		}
	}
	if ( i ) {                                                                      // λ豸û
		DisableRootHubPort( );
#if DE_PRINTF			
		printf( "Disable host port because of disconnect\n" );
#endif		
		return( ERR_USB_DISCON );
	}
	SetUsbSpeed( 1 );                                                              // õǰUSBٶ
	s = CtrlGetDeviceDescr( );                                                     // ȡ豸
	if ( s == ERR_SUCCESS ) {
#if DE_PRINTF			
	  printf( "GetDevDescr: " );		
		for ( i = 0; i < ( (PUSB_SETUP_REQ)SetupGetDevDescr ) -> wLengthL; i ++ ) printf( "x%02X ", (UINT16)( Com_Buffer[i] ) );
		printf( "\n" );                                                             // ʾ
#endif
		dv_cls = ( (PXUSB_DEV_DESCR)Com_Buffer ) -> bDeviceClass;                     // 豸
		s = CtrlSetUsbAddress( ( (PUSB_SETUP_REQ)SetupSetUsbAddr ) -> wValueL );    // USB豸ַ
		if ( s == ERR_SUCCESS ) {
			s = CtrlGetConfigDescr( );                                                // ȡ
			if ( s == ERR_SUCCESS ) {
				cfg = ( (PXUSB_CFG_DESCR)Com_Buffer ) -> bConfigurationValue;
#if DE_PRINTF					
			  printf( "GetCfgDescr: " );				
				for ( i = 0; i < ( (PXUSB_CFG_DESCR)Com_Buffer ) -> wTotalLengthL; i ++ ) 
					printf( "x%02X ", (UINT16)( Com_Buffer[i] ) );
				printf("\n");
#endif				
/* ,ȡ˵/˵ַ/˵С,±endp_addrendp_size */
				if_cls = ( (PXUSB_CFG_DESCR_LONG)Com_Buffer ) -> itf_descr.bInterfaceClass; // ӿ
				if ( (dv_cls == 0x00) && (if_cls == USB_DEV_CLASS_STORAGE) ) {            // USB洢豸,ȷU					
//					s = CtrlSetUsbConfig( cfg );                                     // USB豸
//                    if ( s == ERR_SUCCESS )
					{
						CH554DiskStatus = DISK_USB_ADDR;
						return( ERR_SUCCESS );
					}
//					else return( ERR_USB_UNSUPPORT );
				}
				else {
					return( ERR_USB_UNSUPPORT );
				}
			}
		}
	}
#if DE_PRINTF		
	printf( "InitRootDev Err = %02X\n", (UINT16)s );
#endif
	CH554DiskStatus = DISK_CONNECT;
	SetUsbSpeed( 1 );                                                              // ĬΪȫ
	return( s );
}
#endif
/*******************************************************************************
* Function Name  : InitUSB_Host
* Description    : ʼUSB
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void  InitUSB_Host( void )
{
    UINT8   i;
    IE_USB = 0;
//  LED_CFG = 1;
//  LED_RUN = 0;
    USB_CTRL = bUC_HOST_MODE;                                                    // 趨ģʽ
    UHOST_CTRL &= ~bUH_PD_DIS;                                                   //
    USB_DEV_AD = 0x00;
    UH_EP_MOD = bUH_EP_TX_EN | bUH_EP_RX_EN ;
    UH_RX_DMA = RxBuffer;
    UH_TX_DMA = TxBuffer;
    UH_RX_CTRL = 0x00;
    UH_TX_CTRL = 0x00;
    USB_CTRL = bUC_HOST_MODE | bUC_INT_BUSY;// | bUC_DMA_EN;                     // USBDMA,жϱ־δǰԶͣ
//  UHUB0_CTRL = 0x00;
//  UHUB1_CTRL = 0x00;
//  UH_SETUP = bUH_SOF_EN;
    USB_INT_FG = 0xFF;                                                           // жϱ־
    for ( i = 0; i != 2; i ++ )
    {
        DisableRootHubPort( );                                                   // 
    }
    USB_INT_EN = bUIE_TRANSFER | bUIE_DETECT;
//  IE_USB = 1;                                                                  // ѯʽ
}
