/* 2014.09.09
*****************************************
**   Copyright  (C)  W.ch  1999-2015   **
**   Web:      http://wch.cn           **
*****************************************
**  USB-flash File Interface for CH554 **
**  KC7.0@MCS51                        **
*****************************************
*/
/* CH554 Uļϵͳӿ, ֧: FAT12/FAT16/FAT32 */

//#include "CH554BAS.H"

#ifndef __CH554UFI_H__
#define __CH554UFI_H__

#define CH554_LIB_VER		0x11

//#define DISK_BASE_BUF_LEN		512	/* ĬϵĴݻСΪ512ֽ,Ϊ0ֹڱļж建ӦópDISK_BASE_BUFָ */
/* ҪôݻԽԼRAM,ôɽDISK_BASE_BUF_LENΪ0Խֹڱļж建,ӦóڵCH554LibInit֮ǰõĻʼַpDISK_BASE_BUF */

//#define NO_DEFAULT_ACCESS_SECTOR	1		/* ֹĬϵĴдӳ,бдĳ */
//#define NO_DEFAULT_DISK_CONNECT		1		/* ֹĬϵļӳ,бдĳ */
//#define NO_DEFAULT_FILE_ENUMER		1		/* ֹĬϵļöٻص,бдĳ */

#ifdef __cplusplus
extern "C" {
#endif

/* ********************************************************************************************************************* */

/* FILE: CH554UF.H */

/*  */
#ifndef ERR_SUCCESS
#define ERR_SUCCESS				0x00	/* ɹ */
#endif
#ifndef ERR_DISK_DISCON
#define ERR_CH554_ERROR			0x81	/* CH554Ӳ,ҪλCH554 */
//#define ERR_DISK_DISCON			0x82	/* δ,ܴѾϿ */
#define ERR_STATUS_ERR			0x83	/* ״̬,ӻ߶Ͽ */
#define ERR_HUB_PORT_FREE		0x84	/* USB-HUBѾӵHUB˿δӴ,ܴѾϿ */
#define ERR_MBR_ERROR			0x91	/* ̵¼Ч,ܴδδʽ */
#define ERR_TYPE_ERROR			0x92	/* ̷Ͳ֧,ֻ֧FAT12/FAT16/BigDOS/FAT32,Ҫɴ̹· */
#define ERR_BPB_ERROR			0xA1	/* δʽ,߲,ҪWINDOWSĬϲ¸ʽ */
#define ERR_TOO_LARGE			0xA2	/* ̷ʽ4GB,250GB,ҪWINDOWSĬϲ¸ʽ */
#define ERR_FAT_ERROR			0xA3	/* ̵ļϵͳ֧,ֻ֧FAT12/FAT16/FAT32,ҪWINDOWSĬϲ¸ʽ */
#define ERR_DISK_FULL			0xB1	/* ļ̫,ʣռ̫ٻѾû,Ҫ */
#define ERR_FDT_OVER			0xB2	/* Ŀ¼ļ̫,ûпеĿ¼,FAT12/FAT16Ŀ¼µļӦ500,Ҫ */
#define ERR_MISS_DIR			0xB3	/* ָ·ĳĿ¼ûҵ,Ŀ¼ƴ */
#define ERR_FILE_CLOSE			0xB4	/* ļѾر,Ҫʹ,Ӧ´ļ */
#define ERR_OPEN_DIR			0x41	/* ָ·Ŀ¼ */
#define ERR_MISS_FILE			0x42	/* ָ·ļûҵ,ļƴ */
#define ERR_FOUND_NAME			0x43	/* ͨƥļ,ļ·,Ҫʹ,Ӧô򿪸ļ */
#endif
/* 2XH-3XHUSBʽͨѶʧܴ,CH554ӳģCH375ķ */
/* 1XHUSBʽĲ״̬,CH554ӳģCH375ķ */
#ifndef ERR_USB_CONNECT
#define	ERR_USB_CONNECT_LS		0x13	/* ⵽USB豸¼ */
#define	ERR_USB_CONNECT			0x15	/* ⵽USB豸¼,Ѿ */
#define	ERR_USB_DISCON			0x16	/* ⵽USB豸Ͽ¼,ѾϿ */
#define	ERR_USB_BUF_OVER		0x17	/* USB̫໺ */
#define	ERR_USB_DISK_ERR		0x1F	/* USB洢ʧ,ڳʼʱUSB洢֧,ڶдпǴ𻵻ѾϿ */
#define	ERR_USB_TRANSFER		0x20	/* NAK/STALLȸ0x20~0x2F */
#endif

/* ̼ļ״̬ */
#define DISK_UNKNOWN			0x00	/* δʼ,δ֪״̬ */
#define DISK_DISCONNECT			0x01	/* ûӻѾϿ */
#define DISK_CONNECT			0x02	/* Ѿ,δʼ޷ʶô */
#define DISK_USB_ADDR			0x04	/* ѾUSB豸ַ,δUSBͳʼ */
#define DISK_MOUNTED			0x05	/* Ѿʼɹ,δļϵͳļϵͳ֧ */
#define DISK_READY				0x10	/* Ѿ̵ļϵͳܹ֧ */
#define DISK_OPEN_ROOT			0x12	/* Ѿ򿪸Ŀ¼,ģʽ,ֻΪλдĿ¼,ʹúر,עFAT12/FAT16Ŀ¼ǹ̶ */
#define DISK_OPEN_DIR			0x13	/* ѾĿ¼,ģʽ,ֻΪλдĿ¼ */
#define DISK_OPEN_FILE			0x14	/* Ѿļ,ģʽ,Ϊλݶд */
#define DISK_OPEN_FILE_B		0x15	/* Ѿļ,ֽģʽ,ֽΪλݶд */

/* FATͱ־ */
#ifndef DISK_FAT16
#define DISK_FS_UNKNOWN			0		/* δ֪ļϵͳ */
#define DISK_FAT12				1		/* FAT12ļϵͳ */
#define DISK_FAT16				2		/* FAT16ļϵͳ */
#define DISK_FAT32				3		/* FAT32ļϵͳ */
#endif

#ifndef DEF_SECTOR_SIZE
#define DEF_SECTOR_SIZE			0x0200	/* ̵С */
#define CH554vSectorSizeH		2		/* ̵Сĸֽ,ֽ0x00,ֵ20x200 */
#define CH554vSectorSizeB		9		/* log2(CH554vSectorSizeH) */
#endif

/* FATļĿ¼Ϣ */
typedef struct _FAT_DIR_INFO {
	UINT8	DIR_Name[11];				/* 00H,ļ,11ֽ,㴦ո */
	UINT8	DIR_Attr;					/* 0BH,ļ,ο˵ */
	UINT8	DIR_NTRes;					/* 0CH */
	UINT8	DIR_CrtTimeTenth;			/* 0DH,ļʱ,0.1뵥λ */
	UINT16	DIR_CrtTime;				/* 0EH,ļʱ */
	UINT16	DIR_CrtDate;				/* 10H,ļ */
	UINT16	DIR_LstAccDate;				/* 12H,һδȡ */
	UINT16	DIR_FstClusHI;				/* 14H */
	UINT16	DIR_WrtTime;				/* 16H,ļ޸ʱ,οMAKE_FILE_TIME */
	UINT16	DIR_WrtDate;				/* 18H,ļ޸,οMAKE_FILE_DATA */
	UINT16	DIR_FstClusLO;				/* 1AH */
	UINT32	DIR_FileSize;				/* 1CH,ļ */
} FAT_DIR_INFO;							/* 20H */

typedef FAT_DIR_INFO xdata *PX_FAT_DIR_INFO;

/* ļ */
#define ATTR_READ_ONLY			0x01	/* ļΪֻ */
#define ATTR_HIDDEN				0x02	/* ļΪ */
#define ATTR_SYSTEM				0x04	/* ļΪϵͳ */
#define ATTR_VOLUME_ID			0x08	/*  */
#define ATTR_DIRECTORY			0x10	/* Ŀ¼ */
#define ATTR_ARCHIVE			0x20	/* ļΪ浵 */
#define ATTR_LONG_NAME			( ATTR_READ_ONLY | ATTR_HIDDEN | ATTR_SYSTEM | ATTR_VOLUME_ID )
/* ļ UINT8 */
/* bit0 bit1 bit2 bit3 bit4 bit5 bit6 bit7 */
/*  ֻ      ϵ      Ŀ      δ   */
/*        ͳ      ¼               */
/* ļʱ UINT16 */
/* Time = (Hour<<11) + (Minute<<5) + (Second>>1) */
#define MAKE_FILE_TIME( h, m, s )	( (h<<11) + (m<<5) + (s>>1) )	/* ָʱļʱ */
/* ļ UINT16 */
/* Date = ((Year-1980)<<9) + (Month<<5) + Day */
#define MAKE_FILE_DATE( y, m, d )	( ((y-1980)<<9) + (m<<5) + d )	/* ָյļ */

/* ļ */
#define PATH_WILDCARD_CHAR		0x2A	/* ·ͨ '*' */
#define PATH_SEPAR_CHAR1		0x5C	/* ·ķָ '\' */
#define PATH_SEPAR_CHAR2		0x2F	/* ·ķָ '/' */
#ifndef MAX_PATH_LEN
#define MAX_PATH_LEN			32		/* ·,бָܷСԼ·00H */
#endif

/* ⲿ */
typedef union _CMD_PARAM {
	struct {
		UINT8	mBuffer[ MAX_PATH_LEN ];
	} Other;
	struct {
		UINT32	mTotalSector;			/* : ǰ߼̵ */
		UINT32	mFreeSector;			/* : ǰ߼̵ʣ */
		UINT32	mSaveValue;
	} Query;							/* CMD_DiskQuery, ѯϢ */
	struct {
		UINT8	mPathName[ MAX_PATH_LEN ];	/* : ·: [̷,ð,б,Ŀ¼ļչ...,00H], ̷ðſʡ, "C:\DIR1.EXT\DIR2\FILENAME.EXT",00H */
	} Open;								/* CMD_FileOpen, ļ */
//	struct {
//		UINT8	mPathName[ MAX_PATH_LEN ];	/* : ·: [̷,ð,б,Ŀ¼ļչ(ͨ*)...,00H], ̷ðſʡ, "C:\DIR1.EXT\DIR2\FILE*",00H */
//	} Open;								/* CMD_FileOpen, öļ, CH554vFileSizeλΪ1xFileNameEnumer,Ϊ0򷵻ָŵļ */
	struct {
		UINT8	mUpdateLen;				/* : Ƿ³: 0ֹ,1 */
	} Close;							/* CMD_FileClose, رյǰļ */
	struct {
		UINT8	mPathName[ MAX_PATH_LEN ];	/* : ·: [̷,ð,б,Ŀ¼ļչ...,00H], ̷ðſʡ, "C:\DIR1.EXT\DIR2\FILENAME.EXT",00H */
	} Create;							/* CMD_FileCreate, ½ļ,ļѾɾ½ */
	struct {
		UINT8	mPathName[ MAX_PATH_LEN ];	/* : ·: [̷,ð,б,Ŀ¼ļչ...,00H], ̷ðſʡ, "C:\DIR1.EXT\DIR2\FILENAME.EXT",00H */
	} Erase;							/* CMD_FileErase, ɾļر */
	struct {
		UINT32	mFileSize;				/* : µļ,Ϊ0FFFFFFFFH޸, : ԭ */
		UINT16	mFileDate;				/* : µļ,Ϊ0FFFFH޸, : ԭ */
		UINT16	mFileTime;				/* : µļʱ,Ϊ0FFFFH޸, : ԭʱ */
		UINT8	mFileAttr;				/* : µļ,Ϊ0FFH޸, : ԭ */
	} Modify;							/* CMD_FileQuery, ѯǰļϢ; CMD_FileModify, ѯ޸ĵǰļϢ */
	struct {
		UINT32	mSaveCurrClus;
		UINT32	mSaveLastClus;
	} Alloc;							/* CMD_FileAlloc, ļȵΪļĴ̿ռ */
	struct {
		UINT32	mSectorOffset;			/* : ƫ,0ƶļͷ,0FFFFFFFFHƶļβ, : ǰļָӦľ, 0FFFFFFFFHѵļβ */
		UINT32	mLastOffset;
	} Locate;							/* CMD_FileLocate, ƶǰļָ */
	struct {
		UINT8	mSectorCount;			/* : ȡ, : ʵʶȡ */
		UINT8	mActCnt;
		UINT8	mLbaCount;
		UINT8	mRemainCnt;
		PUINT8X	mDataBuffer;			/* : ʼַ, : ǰַ */
		UINT32	mLbaStart;
	} Read;								/* CMD_FileRead, ӵǰļȡ */
	struct {
		UINT8	mSectorCount;			/* : д, : ʵд */
		UINT8	mActCnt;
		UINT8	mLbaCount;
		UINT8	mAllocCnt;
		PUINT8X	mDataBuffer;			/* : ʼַ, : ǰַ */
		UINT32	mLbaStart;
		UINT32	mSaveValue;
	} Write;							/* CMD_FileWrite, ǰļд */
	struct {
		UINT32	mDiskSizeSec;			/* : ̵, ״εʱ */
	} DiskReady;						/* CMD_DiskReady, ѯ̾ */
	struct {
		UINT32	mByteOffset;			/* : ֽΪλƫ, ֽΪλļָ, : ǰļָӦľ, 0FFFFFFFFHѵļβ */
		UINT32	mLastOffset;
	} ByteLocate;						/* CMD_ByteLocate, ֽΪλƶǰļָ */
	struct {
		UINT16	mByteCount;				/* : ׼ȡֽ, : ʵʶֽ */
		PUINT8X	mByteBuffer;			/* : ָŶݿĻ */
		UINT16	mActCnt;
	} ByteRead;							/* CMD_ByteRead, ֽΪλӵǰļȡݿ */
	struct {
		UINT16	mByteCount;				/* : ׼дֽ, : ʵдֽ */
		PUINT8X	mByteBuffer;			/* : ָŶݿĻ */
		UINT16	mActCnt;
	} ByteWrite;						/* CMD_ByteWrite, ֽΪλǰļдݿ */
	struct {
		UINT8	mSaveVariable;			/* : Ϊ0ָU̵ı,Ϊ0x80ָU̵ı,ֵ򱸷/ */
		UINT8	mReserved[3];
		PUINT8X	mBuffer;				/* : ָӳııݻ,ȲС80ֽ */
	} SaveVariable;						/* CMD_SaveVariable, //ָӳı */
} CMD_PARAM;

typedef CMD_PARAM idata CMD_PARAM_I;
//typedef CMD_PARAM data *P_CMD_PARAM;

/* SCSI */
#ifndef SPC_CMD_INQUIRY
#define SPC_CMD_INQUIRY			0x12
#define SPC_CMD_READ_CAPACITY	0x25
#define SPC_CMD_READ10			0x28
#define SPC_CMD_WRITE10			0x2A
#define SPC_CMD_TEST_READY		0x00
#define SPC_CMD_REQUEST_SENSE	0x03
#define SPC_CMD_MODESENSE6		0x1A
#define SPC_CMD_MODESENSE10		0x5A
#define SPC_CMD_START_STOP		0x1B
#endif

/* FILE: CH554UFI.C */

#define EN_DISK_WRITE			1

#ifndef DISK_BASE_BUF_LEN
#define DISK_BASE_BUF_LEN		512		/* ĬϵĴݻСΪ512ֽ,Ϊ0ֹ.Hļж建ӦópDISK_BASE_BUFָ */
#endif

/* ӳṩı */
extern	UINT8DV	CH554IntStatus;				/* CH554ж״̬ */
extern	UINT8DV	CH554DiskStatus;			/* ̼ļ״̬ */
extern	UINT8X	CH554vDiskFat;				/* ߼̵FAT־:1=FAT12,2=FAT16,3=FAT32 */
extern	UINT8	CH554vSecPerClus;			/* ߼̵ÿ */
extern	UINT32X	CH554vStartLba;				/* ߼̵ʼLBA */
extern	UINT32X	CH554vDiskRoot;				/* FAT16ΪĿ¼ռ,FAT32ΪĿ¼ʼغ */
extern	UINT32X	CH554vDataStart;			/* ߼̵ʼLBA */
extern	UINT32X	CH554vStartCluster;			/* ǰļĿ¼ʼغ */
extern	UINT32	CH554vFileSize;				/* ǰļĳ */
extern	UINT32	CH554vCurrentOffset;		/* ǰļָ,ǰдλõֽƫ */
extern	UINT32X	CH554vFdtLba;				/* ǰFDTڵLBAַ */
extern	UINT32	CH554vLbaCurrent;			/* ǰдĴʼLBAַ */
extern	UINT16X	CH554vFdtOffset;			/* ǰFDTڵƫƵַ */
extern	UINT8X	CH554vCurrentLun;			/* ̵ǰ߼Ԫ */
extern	BOOL	CH554vSubClassIs6;			/* USB洢豸Ϊ6,06 */
extern	PUINT8X	data	pDISK_BASE_BUF;		/* ָⲿRAMĴݻ,ȲСCH554vSectorSizeH,Ӧóʼ */
extern	PUINT8X	xdata	pDISK_FAT_BUF;		/* ָⲿRAMĴFATݻ,ȲСCH554vSectorSizeH,Ӧóʼ */

extern	CMD_PARAM_I	mCmdParam;				/*  */

extern	UINT8X	RxBuffer[ MAX_PACKET_SIZE ];  // IN, must even address
extern	UINT8X	TxBuffer[ MAX_PACKET_SIZE ];  // OUT, must even address

#ifndef	pSetupReq
#define	pSetupReq	((PXUSB_SETUP_REQ)TxBuffer)
#endif
#ifndef	pCBW
#define	pCBW		((PXUDISK_BOC_CBW)TxBuffer)
#define	pCSW		((PXUDISK_BOC_CSW)RxBuffer)
#endif
#ifndef	pBOC_buf
#define	pBOC_buf	(TxBuffer+((USB_BO_CBW_SIZE+4)&0xFE))
#endif

#if		DISK_BASE_BUF_LEN > 0
extern	UINT8X	DISK_BASE_BUF[ DISK_BASE_BUF_LEN ];	/* ⲿRAMĴݻ,Ϊһĳ */
#endif
extern	UINT8	CH554ReadSector( UINT8 SectCount, PUINT8X DataBuf );	/* Ӵ̶ȡݵ */
#ifdef	EN_DISK_WRITE
extern	UINT8	CH554WriteSector( UINT8 SectCount, PUINT8X DataBuf );	/* еĶݿд */
#endif

extern	UINT8	CH554DiskConnect( void );	/* ǷӲ´״̬ */
extern	void	xFileNameEnumer( void );	/* ⲿӳ,ļöٻصӳ */

extern	UINT8	CH554LibInit( void );		/* ʼCH554,ɹ0 */

/* ӳṩӳ */
/* ӳ, ļӳCH554File*ʹ̲ѯӳCH554DiskQueryܻõݻpDISK_BASE_BUF,
   пpDISK_BASE_BUFб˴Ϣ, Ա뱣֤pDISK_BASE_BUF;,
   RAM, ҪpDISK_BASE_BUFʱ;, ôʱCH554DirtyBuffer̻ */
extern	UINT8	CH554GetVer( void );		/* ȡǰӳİ汾 */
extern	void	CH554DirtyBuffer( void );	/* ̻ */
extern	UINT8	CH554BulkOnlyCmd( PUINT8X DataBuf );	/* ִлBulkOnlyЭ */
extern	UINT8	CH554DiskReady( void );		/* ѯǷ׼ */
extern	UINT8	CH554AnalyzeError( UINT8 iMode );	/* USBʧܷCH554IntStatusش״̬ */
extern	UINT8	CH554FileOpen( void );		/* ļöļ */
extern	UINT8	CH554FileClose( void );		/* رյǰļ */
#ifdef	EN_DISK_WRITE
extern	UINT8	CH554FileErase( void );		/* ɾļر */
extern	UINT8	CH554FileCreate( void );	/* ½ļ,ļѾɾ½ */
extern	UINT8	CH554FileAlloc( void );		/* ļȵΪļĴ̿ռ */
#endif
extern	UINT8	CH554FileModify( void );	/* ѯ޸ĵǰļϢ */
extern	UINT8	CH554FileQuery( void );		/* ѯǰļϢ */
extern	UINT8	CH554FileLocate( void );	/* ƶǰļָ */
extern	UINT8	CH554FileRead( void );		/* ӵǰļȡݵָ */
#ifdef	EN_DISK_WRITE
extern	UINT8	CH554FileWrite( void );		/* ǰļдָ */
#endif
extern	UINT8	CH554ByteLocate( void );	/* ֽΪλƶǰļָ */
extern	UINT8	CH554ByteRead( void );		/* ֽΪλӵǰλöȡݿ */
#ifdef	EN_DISK_WRITE
extern	UINT8	CH554ByteWrite( void );		/* ֽΪλǰλдݿ */
#endif
extern	UINT8	CH554DiskQuery( void );		/* ѯϢ */
extern	void	CH554SaveVariable( void );	/* //ָӳı,ӳڶоƬU֮л */

extern	void	mDelayuS( UINT16 n );		// uSΪλʱ
extern	void	mDelaymS( UINT16 n );		// mSΪλʱ
extern	UINT8	USBHostTransact( UINT8 endp_pid, UINT8 tog, UINT16 timeout );	// CH554,ĿĶ˵ַ/PID,ͬ־,NAKʱ,0ɹ,ʱ/
extern	UINT8	HostCtrlTransfer( PUINT8X DataBuf, PUINT8I RetLen );	// ִпƴ,8ֽpSetupReq,DataBufΪѡշ,ʵշȷReqLenָı
extern	void	CopySetupReqPkg( PUINT8C pReqPkt );  // ƿƴ
//extern	UINT8	CtrlGetDeviceDescr( void );  // ȡ豸,TxBuffer
extern	UINT8	CtrlGetConfigDescr( void );  // ȡ,TxBuffer
//extern	UINT8	CtrlSetUsbAddress( UINT8 addr );  // USB豸ַ
extern	UINT8	CtrlSetUsbConfig( UINT8 cfg );  // USB豸
extern	UINT8	CtrlClearEndpStall( UINT8 endp );  // ˵STALL
//extern	UINT8	CtrlGetHubDescr( void );  // ȡHUB,TxBuffer
//extern	UINT8	HubGetPortStatus( UINT8 HubPortIndex );  // ѯHUB˿״̬,TxBuffer
//extern	UINT8	HubSetPortFeature( UINT8 HubPortIndex, UINT8 FeatureSelt );  // HUB˿
//extern	UINT8	HubClearPortFeature( UINT8 HubPortIndex, UINT8 FeatureSelt );  // HUB˿

#ifdef __cplusplus
}
#endif

#endif
