/* 2014.09.09
*****************************************
**   Copyright  (C)  W.ch  1999-2015   **
**   Web:      http://wch.cn           **
*****************************************
**  USB-flash File Interface for CH554 **
**  KC7.0@MCS51                        **
*****************************************
*/
/* CH554 Uļϵͳӿ, ֧: FAT12/FAT16/FAT32 */

//#define DISK_BASE_BUF_LEN		512	/* ĬϵĴݻСΪ512ֽ,Ϊ0ֹڱļж建ӦópDISK_BASE_BUFָ */
/* ҪôݻԽԼRAM,ôɽDISK_BASE_BUF_LENΪ0Խֹڱļж建,ӦóڵCH554LibInit֮ǰõĻʼַpDISK_BASE_BUF */

//#define NO_DEFAULT_ACCESS_SECTOR	1		/* ֹĬϵĴдӳ,бдĳ */
//#define NO_DEFAULT_DISK_CONNECT		1		/* ֹĬϵļӳ,бдĳ */
//#define NO_DEFAULT_FILE_ENUMER		1		/* ֹĬϵļöٻص,бдĳ */

//#include "CH554.H"
#include "CH554UFI.H"

CMD_PARAM_I	mCmdParam;						/*  */
#if		DISK_BASE_BUF_LEN > 0
UINT8X	DISK_BASE_BUF[ DISK_BASE_BUF_LEN ] _at_ 0x0080;	/* ⲿRAMĴݻ,Ϊһĳ */
#endif

/* ³ԸҪ޸ */

#ifndef	NO_DEFAULT_ACCESS_SECTOR		/* ӦóжNO_DEFAULT_ACCESS_SECTORԽֹĬϵĴдӳ,Ȼбдĳ */
//if ( use_external_interface ) {  // 滻Uײдӳ
//    CH554DiskStatus=DISK_MOUNTED;  // ǿƿ豸ӳɹ(ֻļϵͳ)
//}

#pragma ot(8,size)

UINT8	CH554ReadSector( UINT8 SectCount, PUINT8X DataBuf )  /* Ӵ̶ȡݵ */
{
	UINT8	retry;
//	if ( use_external_interface ) return( extReadSector( CH554vLbaCurrent, SectCount, DataBuf ) );  /* ⲿӿ */
	for( retry = 0; retry < 3; retry ++ ) {  /*  */
		pCBW -> mCBW_DataLen0 = 0;  /* ݴ䳤 */
		pCBW -> mCBW_DataLen1 = SectCount << CH554vSectorSizeB - 8;
		pCBW -> mCBW_DataLen2 = 0;
		pCBW -> mCBW_DataLen3 = 0;
		pCBW -> mCBW_Flag = 0x80;
		pCBW -> mCBW_LUN = CH554vCurrentLun;
		pCBW -> mCBW_CB_Len = 10;
		pCBW -> mCBW_CB_Buf[ 0 ] = SPC_CMD_READ10;
		pCBW -> mCBW_CB_Buf[ 1 ] = 0x00;
		pCBW -> mCBW_CB_Buf[ 2 ] = *(PUINT8)&CH554vLbaCurrent;
		pCBW -> mCBW_CB_Buf[ 3 ] = *( (PUINT8)&CH554vLbaCurrent + 1 );
		pCBW -> mCBW_CB_Buf[ 4 ] = *( (PUINT8)&CH554vLbaCurrent + 2 );
		pCBW -> mCBW_CB_Buf[ 5 ] = *( (PUINT8)&CH554vLbaCurrent + 3 );
		pCBW -> mCBW_CB_Buf[ 6 ] = 0x00;
		pCBW -> mCBW_CB_Buf[ 7 ] = 0x00;
		pCBW -> mCBW_CB_Buf[ 8 ] = SectCount;
		pCBW -> mCBW_CB_Buf[ 9 ] = 0x00;
		CH554BulkOnlyCmd( DataBuf );  /* ִлBulkOnlyЭ */
		if ( CH554IntStatus == ERR_SUCCESS ) {
			return( ERR_SUCCESS );
		}
		CH554IntStatus = CH554AnalyzeError( retry );
		if ( CH554IntStatus != ERR_SUCCESS ) {
			return( CH554IntStatus );
		}
	}
	return( CH554IntStatus = ERR_USB_DISK_ERR );  /* ̲ */
}

#ifdef	EN_DISK_WRITE
UINT8	CH554WriteSector( UINT8 SectCount, PUINT8X DataBuf )  /* еĶݿд */
{
	UINT8	retry;
//	if ( use_external_interface ) return( extWriteSector( CH554vLbaCurrent, SectCount, DataBuf ) );  /* ⲿӿ */
	for( retry = 0; retry < 3; retry ++ ) {  /*  */
		pCBW -> mCBW_DataLen0 = 0;  /* ݴ䳤 */
		pCBW -> mCBW_DataLen1 = SectCount << CH554vSectorSizeB - 8;
		pCBW -> mCBW_DataLen2 = 0;
		pCBW -> mCBW_DataLen3 = 0;
		pCBW -> mCBW_Flag = 0x00;
		pCBW -> mCBW_LUN = CH554vCurrentLun;
		pCBW -> mCBW_CB_Len = 10;
		pCBW -> mCBW_CB_Buf[ 0 ] = SPC_CMD_WRITE10;
		pCBW -> mCBW_CB_Buf[ 1 ] = 0x00;
		pCBW -> mCBW_CB_Buf[ 2 ] = *(PUINT8)&CH554vLbaCurrent;
		pCBW -> mCBW_CB_Buf[ 3 ] = *( (PUINT8)&CH554vLbaCurrent + 1 );
		pCBW -> mCBW_CB_Buf[ 4 ] = *( (PUINT8)&CH554vLbaCurrent + 2 );
		pCBW -> mCBW_CB_Buf[ 5 ] = *( (PUINT8)&CH554vLbaCurrent + 3 );
		pCBW -> mCBW_CB_Buf[ 6 ] = 0x00;
		pCBW -> mCBW_CB_Buf[ 7 ] = 0x00;
		pCBW -> mCBW_CB_Buf[ 8 ] = SectCount;
		pCBW -> mCBW_CB_Buf[ 9 ] = 0x00;
		CH554BulkOnlyCmd( DataBuf );  /* ִлBulkOnlyЭ */
		if ( CH554IntStatus == ERR_SUCCESS ) {
			mDelayuS( 200 );  /* дʱ */
			return( ERR_SUCCESS );
		}
		CH554IntStatus = CH554AnalyzeError( retry );
		if ( CH554IntStatus != ERR_SUCCESS ) {
			return( CH554IntStatus );
		}
	}
	return( CH554IntStatus = ERR_USB_DISK_ERR );  /* ̲ */
}
#endif
#endif  // NO_DEFAULT_ACCESS_SECTOR

#ifndef	NO_DEFAULT_DISK_CONNECT			/* ӦóжNO_DEFAULT_DISK_CONNECTԽֹĬϵļӳ,Ȼбдĳ */
/* Ƿ */
UINT8	CH554DiskConnect( void )
{
	USB_DEV_AD &= 0x7F;
	if ( USB_DEV_AD == USB_DEVICE_ADDR ) {  /* USB豸 */
		if ( UHOST_CTRL & bUH_PORT_EN ) {  /* USB豸δ */
			return( ERR_SUCCESS );  /* USB豸Ѿδ */
		}
		else if ( USB_MIS_ST & bUMS_DEV_ATTACH ) {  /* USB豸 */
mDiskConnect:
			CH554DiskStatus = DISK_CONNECT;  /* Ͽ */
			return( ERR_SUCCESS );  /* ⲿHUBUSB豸Ѿӻ߶Ͽ */
		}
		else {  /* USB豸Ͽ */
mDiskDisconn:
			CH554DiskStatus = DISK_DISCONNECT;
			return( ERR_USB_DISCON );
		}
	}
#ifndef	FOR_ROOT_UDISK_ONLY
	else if ( USB_DEV_AD > 0x10 && USB_DEV_AD <= 0x14 ) {  /* ⲿHUBĶ˿µUSB豸 */
		if ( UHOST_CTRL & bUH_PORT_EN ) {  /* ⲿHUBδ */
			TxBuffer[ MAX_PACKET_SIZE - 1 ] = USB_DEV_AD;  /*  */
			USB_DEV_AD = USB_DEVICE_ADDR - 1 + ( USB_DEV_AD >> 4 );  /* USB˵USBַָHUB */
			CH554IntStatus = HubGetPortStatus( TxBuffer[ MAX_PACKET_SIZE - 1 ] & 0x0F );  /* ѯHUB˿״̬,TxBuffer */
			if ( CH554IntStatus == ERR_SUCCESS ) {
				if ( TxBuffer[2] & (1<<(HUB_C_PORT_CONNECTION-0x10)) ) {  /* ⵽HUB˿ϵĲ¼ */
					CH554DiskStatus = DISK_DISCONNECT;  /* ٶΪHUB˿ϵUSB豸Ͽ */
					HubClearPortFeature( TxBuffer[ MAX_PACKET_SIZE - 1 ] & 0x0F, HUB_C_PORT_CONNECTION );  /* HUB˿¼״̬ */
				}
				USB_DEV_AD = TxBuffer[ MAX_PACKET_SIZE - 1 ];  /* USB˵USBַָUSB豸 */
				if ( TxBuffer[0] & (1<<HUB_PORT_CONNECTION) ) {  /* ״̬ */
					if ( CH554DiskStatus < DISK_CONNECT ) {
						CH554DiskStatus = DISK_CONNECT;  /* Ͽ */
					}
					return( ERR_SUCCESS );  /* USB豸Ѿӻ߶Ͽ */
				}
				else {
//					CH554DiskStatus = DISK_DISCONNECT;
//					return( ERR_USB_DISCON );
					CH554DiskStatus = DISK_CONNECT;
					return( ERR_HUB_PORT_FREE );  /* HUBѾӵHUB˿δӴ */
				}
			}
			else {
				USB_DEV_AD = TxBuffer[ MAX_PACKET_SIZE - 1 ];  /* USB˵USBַָUSB豸 */
				if ( CH554IntStatus == ERR_USB_DISCON ) {
//					CH554DiskStatus = DISK_DISCONNECT;
//					return( ERR_USB_DISCON );
					goto mDiskDisconn;
				}
				else {
					CH554DiskStatus = DISK_CONNECT;  /* HUBʧ */
					return( CH554IntStatus );
				}
			}
		}
		else if ( USB_MIS_ST & bUMS_DEV_ATTACH ) {  /* USB豸,ⲿHUBUSB豸Ѿӻ߶Ͽ */
//			CH554DiskStatus = DISK_CONNECT;  /* Ͽ */
//			return( ERR_SUCCESS );  /* ⲿHUBUSB豸Ѿӻ߶Ͽ */
			goto mDiskConnect;
		}
		else {  /* ⲿHUBϿ */
			CH554DiskStatus = DISK_DISCONNECT;
		}
	}
#endif
	else {
//		CH554DiskStatus = DISK_DISCONNECT;
//		return( ERR_USB_DISCON );
		goto mDiskDisconn;
	}
}
#endif  // NO_DEFAULT_DISK_CONNECT

#pragma ot(8,speed)

#ifndef	NO_DEFAULT_FILE_ENUMER			/* ӦóжNO_DEFAULT_FILE_ENUMERԽֹĬϵļöٻص,Ȼбдĳ */
void xFileNameEnumer( void )			/* ļöٻصӳ */
{
/* ָöCH554vFileSizeΪ0xFFFFFFFFFileOpenôÿһļFileOpenñص
   صxFileNameEnumerغFileOpenݼCH554vFileSizeöֱļĿ¼ǣ
   ڵFileOpen֮ǰһȫֱΪ0FileOpenص󣬱CH554vFdtOffsetõṹFAT_DIR_INFO
   ṹеDIR_AttrԼDIR_NameжǷΪļĿ¼¼Ϣȫֱ
   FileOpenغжϷֵERR_MISS_FILEERR_FOUND_NAMEΪɹȫֱΪЧļ
   ڱصxFileNameEnumerнCH554vFileSizeΪ1ô֪ͨFileOpenǰǻص */
#if		0
	UINT8			i;
	UINT16			FileCount;
	PX_FAT_DIR_INFO	pFileDir;
	PUINT8			NameBuf;
	pFileDir = (PX_FAT_DIR_INFO)( pDISK_BASE_BUF + CH554vFdtOffset );  /* ǰFDTʼַ */
	FileCount = (UINT16)( 0xFFFFFFFF - CH554vFileSize );  /* ǰļö,CH554vFileSizeֵ0xFFFFFFFF,ҵļݼ */
	if ( FileCount < sizeof( FILE_DATA_BUF ) / 12 ) {  /* 黺Ƿ㹻,ٶÿļռ12ֽڴ */
		NameBuf = & FILE_DATA_BUF[ FileCount * 12 ];  /* 㱣浱ǰļĻַ */
		for ( i = 0; i < 11; i ++ ) NameBuf[ i ] = pFileDir -> DIR_Name[ i ];  /* ļ,Ϊ11ַ,δո */
//		if ( pFileDir -> DIR_Attr & ATTR_DIRECTORY ) NameBuf[ i ] = 1;  /* жĿ¼ */
		NameBuf[ i ] = 0;  /* ļ */
	}
#endif
}
#endif  // NO_DEFAULT_FILE_ENUMER

#pragma ot(8,size)

UINT8	CH554LibInit( void )  /* ʼCH554,ɹ0 */
{
	if ( CH554GetVer( ) < CH554_LIB_VER ) return( 0xFF );  /* ȡǰӳİ汾,汾̫򷵻ش */
#if		DISK_BASE_BUF_LEN > 0
	pDISK_BASE_BUF = & DISK_BASE_BUF[0];  /* ָⲿRAMĴݻ */
	pDISK_FAT_BUF = & DISK_BASE_BUF[0];  /* ָⲿRAMĴFATݻ,pDISK_BASE_BUFԽԼRAM */
/* ϣļȡٶ,ôеCH554LibInit֮,pDISK_FAT_BUFָһpDISK_BASE_BUFͬСĻ */
#endif
	CH554DiskStatus = DISK_UNKNOWN;  /* δ֪״̬ */
	CH554vStartLba = 0;  /* ĬΪԶFDDHDD */
	return( ERR_SUCCESS );
}
