
/********************************** (C) COPYRIGHT *******************************
* File Name          : USBHostHUB_KM.C
* Author             : WCH
* Version            : V2.0
* Date               : 2018/07/24
* Description        : ʵּ̡ꡢUö١HIDݡAndroidģʽͨѶ
*******************************************************************************/

#include "..\..\Public\CH554.H"                                               
#include "..\..\Public\Debug.H"
#include "..\USB_LIB\USBHOST.H"
#include <stdio.h>
#include <string.h>

#pragma  NOAREGS

/*ȡ豸*/
UINT8C  SetupGetDevDescr[] = { USB_REQ_TYP_IN, USB_GET_DESCRIPTOR, 0x00, USB_DESCR_TYP_DEVICE, 0x00, 0x00, sizeof( USB_DEV_DESCR ), 0x00 };

/*ȡ*/
UINT8C  SetupGetCfgDescr[] = { USB_REQ_TYP_IN, USB_GET_DESCRIPTOR, 0x00, USB_DESCR_TYP_CONFIG, 0x00, 0x00, 0x04, 0x00 };

/*USBַ*/
UINT8C  SetupSetUsbAddr[] = { USB_REQ_TYP_OUT, USB_SET_ADDRESS, USB_DEVICE_ADDR, 0x00, 0x00, 0x00, 0x00, 0x00 };

/*USB*/
UINT8C  SetupSetUsbConfig[] = { USB_REQ_TYP_OUT, USB_SET_CONFIGURATION, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

/*USBӿ*/
UINT8C  SetupSetUsbInterface[] = { USB_REQ_RECIP_INTERF, USB_SET_INTERFACE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

/*˵STALL*/
UINT8C  SetupClrEndpStall[] = { USB_REQ_TYP_OUT | USB_REQ_RECIP_ENDP, USB_CLEAR_FEATURE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

/*ȡHUB*/
UINT8C  SetupGetHubDescr[] = { HUB_GET_HUB_DESCRIPTOR, HUB_GET_DESCRIPTOR, 0x00, USB_DESCR_TYP_HUB, 0x00, 0x00, sizeof( USB_HUB_DESCR ), 0x00 };

/* HIDв */
UINT8C  SetupSetHIDIdle[]= { 0x21,HID_SET_IDLE,0x00,0x00,0x00,0x00,0x00,0x00 };

/*ȡHID豸*/
UINT8C  SetupGetHIDDevReport[] = { 0x81, USB_GET_DESCRIPTOR, 0x00, USB_DESCR_TYP_REPORT, 0x00, 0x00, 0xFF, 0x00 };

/*ӡ*/
UINT8C  XPrinterReport[] = { 0xA1, 0, 0x00, 0, 0x00, 0x00, 0xF1, 0x03 };

//AOAȡЭ汾
UINT8C  GetProtocol[] = { 0xc0,0x33,0x00,0x00,0x00,0x00,0x02,0x00 };

//ģʽ
UINT8C  TouchAOAMode[] = { 0x40,0x35,0x00,0x00,0x00,0x00,0x00,0x00 };

/* AOA鶨 */
UINT8C  Sendlen[]= {0,4,16,35,39,53,67};
//ַID,ֻAPPصַϢ
UINT8C  StringID[] = {'W','C','H',0x00,                                                                                //manufacturer name
                      'W','C','H','U','A','R','T','D','e','m','o',0x00,                                   //model name
                      0x57,0x43,0x48,0x20,0x41,0x63,0x63,0x65,0x73,0x73,0x6f,0x72,0x79,0x20,0x54,0x65,0x73,0x74,0x00,     //description
                      '1','.','0',0x00 ,                                                                       //version
                      0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,0x63,0x68,0x2e,0x63,0x6e,0,//URI
                      0x57,0x43,0x48,0x41,0x63,0x63,0x65,0x73,0x73,0x6f,0x72,0x79,0x31,0x00                               //serial number
                     };  
//Ӧַ
UINT8C  SetStringID[]= {0x40,0x34,0x00,0x00,0x00,0x00,0x04,0x00,
                        0x40,0x34,0x00,0x00,0x01,0x00,12,0x00,
                        0x40,0x34,0x00,0x00,0x02,0x00,19,0x00,
                        0x40,0x34,0x00,0x00,0x03,0x00,4,0x00,
                        0x40,0x34,0x00,0x00,0x04,0x00,0x0E,0x00,
                        0x40,0x34,0x00,0x00,0x05,0x00,0x0E,0x00
                       };

					   

UINT8X  UsbDevEndp0Size;                                                       //* USB豸Ķ˵0ߴ */
UINT8X  RxBuffer[ MAX_PACKET_SIZE ] _at_ 0x0000 ;                              // IN, must even address
UINT8X  TxBuffer[ MAX_PACKET_SIZE ] _at_ 0x0040 ;                            // OUT, must even address
					   
UINT8 Set_Port = 0;

_RootHubDev xdata ThisUsbDev;                                                   //ROOT
_DevOnHubPort xdata DevOnHubPort[HUB_MAX_PORTS];                                // ٶ:1ⲿHUB,ÿⲿHUBHUB_MAX_PORTS˿(˲)

bit RootHubId;                                                                  // ǰڲroot-hub˿ں:0=HUB0,1=HUB1
bit FoundNewDev;

void main( )
{
    UINT8   i, s,k, len, endp;
    UINT16  loc;
	CfgFsys( );	
	mDelaymS(50);
    mInitSTDIO( );                                                              //Ϊüͨڼʾ
    printf( "Start @ChipID=%02X\n", (UINT16)CHIP_ID );
    InitUSB_Host( );
    FoundNewDev = 0;
    printf( "Wait Device In\n" );
    while ( 1 )
    {
        s = ERR_SUCCESS;
        if ( UIF_DETECT ){                                                       // USBж
            UIF_DETECT = 0;                                                      // жϱ־			
            s = AnalyzeRootHub( );                                               // ROOT-HUB״̬
            if ( s == ERR_USB_CONNECT ) FoundNewDev = 1;						
        }
        if ( FoundNewDev ){                                                      // µUSB豸
            FoundNewDev = 0;
//          mDelaymS( 200 );                                                     // USB豸ղδȶ,ʵȴUSB豸ٺ,ζ
            s = EnumAllRootDevice( );                                            // öROOT-HUB˿ڵUSB豸
            if ( s != ERR_SUCCESS ){						
                printf( "EnumAllRootDev err = %02X\n", (UINT16)s );					
            }
        }

		/* CH554¶ӵHUBöHUB */
		s = EnumAllHubPort( );                                                // öROOT-HUB˿ⲿHUBĶUSB豸
		if ( s != ERR_SUCCESS ){                                              // HUBϿ
			printf( "EnumAllHubPort err = %02X\n", (UINT16)s );
		}

		/* 豸 */
		loc = SearchTypeDevice( DEV_TYPE_MOUSE );                             // ROOT-HUBԼⲿHUB˿ָ͵豸ڵĶ˿ں
		if ( loc != 0xFFFF ){                                                 // ҵ,MOUSEδ?
			printf( "Query Mouse @%04X\n", loc );
			i = (UINT8)( loc >> 8 );
			len = (UINT8)loc;
			SelectHubPort( len );                                             // ѡָROOT-HUB˿,õǰUSBٶԼ豸USBַ
			endp = len ? DevOnHubPort[len-1].GpVar[0] : ThisUsbDev.GpVar[0];        // ж϶˵ĵַ,λ7ͬ־λ
			if ( endp & USB_ENDP_ADDR_MASK ){                                 // ˵Ч
				s = USBHostTransact( USB_PID_IN << 4 | endp & 0x7F, endp & 0x80 ? bUH_R_TOG | bUH_T_TOG : 0, 0 );// CH554,ȡ,NAK
				if ( s == ERR_SUCCESS ){
					endp ^= 0x80;                                             // ͬ־ת
					if ( len ) DevOnHubPort[len-1].GpVar[0] = endp;              // ͬ־λ
					else ThisUsbDev.GpVar[0] = endp;
					len = USB_RX_LEN;                                         // յݳ
					if ( len ) {
						printf("Mouse data: ");
						for ( i = 0; i < len; i ++ ){
							printf("x%02X ",(UINT16)(RxBuffer[i]) );
						}
						printf("\n");
					}
				}
				else if ( s != ( USB_PID_NAK | ERR_USB_TRANSFER ) ) {
					printf("Mouse error %02x\n",(UINT16)s);                   // ǶϿ
				}
			}
			else {
				printf("Mouse no interrupt endpoint\n");
			}
			SetUsbSpeed( 1 );                                                 // ĬΪȫ
		}

		
		/* 豸Ǽ */
		loc = SearchTypeDevice( DEV_TYPE_KEYBOARD );                          // ROOT-HUBԼⲿHUB˿ָ͵豸ڵĶ˿ں
		if ( loc != 0xFFFF ){                                                 // ҵ,KeyBoardδ?
			printf( "Query Keyboard @%04X\n", loc );
			i = (UINT8)( loc >> 8 );
			len = (UINT8)loc;
			SelectHubPort( len );                                             // ѡָROOT-HUB˿,õǰUSBٶԼ豸USBַ
			endp = len ? DevOnHubPort[len-1].GpVar[0] : ThisUsbDev.GpVar[0];        // ж϶˵ĵַ,λ7ͬ־λ
			printf("%02X  ",endp);
			if ( endp & USB_ENDP_ADDR_MASK ){                                 // ˵Ч
				s = USBHostTransact( USB_PID_IN << 4 | endp & 0x7F, endp & 0x80 ? bUH_R_TOG | bUH_T_TOG : 0, 0 );// CH554,ȡ,NAK
				if ( s == ERR_SUCCESS ){
					endp ^= 0x80;                                             // ͬ־ת
					if ( len ) DevOnHubPort[len-1].GpVar[0] = endp;              // ͬ־λ
					else ThisUsbDev.GpVar[0] = endp;
					len = USB_RX_LEN;                                         // յݳ
					if ( len ){
						SETorOFFNumLock(RxBuffer);
						printf("keyboard data: ");
						for ( i = 0; i < len; i ++ ){
							printf("x%02X ",(UINT16)(RxBuffer[i]) );
						}
						printf("\n");
					}
				}
				else if ( s != ( USB_PID_NAK | ERR_USB_TRANSFER ) ){
					printf("keyboard error %02x\n",(UINT16)s);               // ǶϿ
				}
			}
			else{
				printf("keyboard no interrupt endpoint\n");
			}
			SetUsbSpeed( 1 );                                                // ĬΪȫ
		}
		
		/* USBӡ */
		if(TIN0 == 0){                                                          //P10Ϊͣʼӡ
			memset(TxBuffer,0,sizeof(TxBuffer));
			TxBuffer[0]=0x1B;TxBuffer[1]=0x40;TxBuffer[2]=0x1D;TxBuffer[3]=0x55;TxBuffer[4]=0x42;TxBuffer[5]=0x02;TxBuffer[6]=0x18;TxBuffer[7]=0x1D;
			TxBuffer[8]=0x76;TxBuffer[9]=0x30;TxBuffer[10]=0x00;TxBuffer[11]=0x30;TxBuffer[12]=0x00;TxBuffer[13]=0x18;
			loc = SearchTypeDevice( USB_DEV_CLASS_PRINTER );                       // ROOT-HUBԼⲿHUB˿ָ͵豸ڵĶ˿ں
			if ( loc != 0xFFFF ){                                                  // ҵ,ӡδ?
				printf( "Query Printer @%04X\n", loc );
				i = (UINT8)( loc >> 8 );
				len = (UINT8)loc;
				SelectHubPort( len );                                              // ѡָROOT-HUB˿,õǰUSBٶԼ豸USBַ
				endp = len ? DevOnHubPort[len-1].GpVar[0] : ThisUsbDev.GpVar[0];         // ˵ĵַ,λ7ͬ־λ
				printf("%02X  ",endp);  
				if ( endp & USB_ENDP_ADDR_MASK ){                                  // ˵Ч
					UH_TX_LEN = 64;                                                // Ĭݹ״̬׶ΪIN										
					s = USBHostTransact( USB_PID_OUT << 4 | endp & 0x7F, endp & 0x80 ? bUH_R_TOG | bUH_T_TOG : 0, 0xffff );// CH554,ȡ,NAK
					if ( s == ERR_SUCCESS ){
						endp ^= 0x80;                                               // ͬ־ת
						memset(TxBuffer,0,sizeof(TxBuffer));
						UH_TX_LEN = 64;                                             // Ĭݹ״̬׶ΪIN										
						s = USBHostTransact( USB_PID_OUT << 4 | endp & 0x7F, endp & 0x80 ? bUH_R_TOG | bUH_T_TOG : 0, 0xffff );// CH554,ȡ,NAK   											
					}
					else if ( s != ( USB_PID_NAK | ERR_USB_TRANSFER ) ) printf("Printer error %02x\n",(UINT16)s); // ǶϿ
				}
			}
		}				
		
		/* HID豸 */
		loc = SearchTypeDevice( USB_DEV_CLASS_HID );                          // ROOT-HUBԼⲿHUB˿ָ͵豸ڵĶ˿ں			
		if ( loc != 0xFFFF ){                                                 // ҵ
			printf( "Query USB_DEV_CLASS_HID @%04X\n", loc );	
			loc = (UINT8)loc;                                                 //554ֻһUSBֻͰλ
			
			for(k=0;k!=4;k++)
			{	
				//˵ǷЧ
				endp = loc ? DevOnHubPort[loc-1].GpVar[k] : ThisUsbDev.GpVar[k];        // ж϶˵ĵַ,λ7ͬ־λ			
				if ( (endp & USB_ENDP_ADDR_MASK) == 0 ) break;
				
				printf("endp: %02X\n",(UINT16)endp);
				SelectHubPort( loc );                                             // ѡָROOT-HUB˿,õǰUSBٶԼ豸USBַ
				s = USBHostTransact( USB_PID_IN << 4 | endp & 0x7F, endp & 0x80 ? bUH_R_TOG | bUH_T_TOG : 0, 0 );// CH554,ȡ,NAK
				if ( s == ERR_SUCCESS ){
					endp ^= 0x80;                                             // ͬ־ת
					if ( loc ) DevOnHubPort[loc-1].GpVar[k] = endp;              // ͬ־λ
					else ThisUsbDev.GpVar[k] = endp;
					len = USB_RX_LEN;                                         // յݳ
					if ( len ){
						printf("keyboard data: ");
						for ( i = 0; i < len; i ++ ){
							printf("x%02X ",(UINT16)(RxBuffer[i]) );
						}
						printf("\n");
					}
				}
				else if ( s != ( USB_PID_NAK | ERR_USB_TRANSFER ) ){
					printf("keyboard error %02x\n",(UINT16)s);               // ǶϿ
				}
							
			}								
			SetUsbSpeed( 1 );                                                // ĬΪȫ
		}            					

		
		/* 豸ֻȳAOAʽ */
		loc = SearchTypeDevice( DEF_AOA_DEVICE );                            // AOA
		if ( loc != 0xFFFF ){                                                 // ҵ	
			loc = (UINT8)loc;                                                 //ĿǰUSBHOST.C֧ROOTHUBµAndroid,÷loc
				
			endp = ThisUsbDev.GpVar[0];                                       //׼ϴ˵㷢IN		
			if ( (endp & USB_ENDP_ADDR_MASK) != 0 )                           //˵Ч
			{
				SelectHubPort( 0 );                                             // ѡָROOT-HUB˿,õǰUSBٶԼ豸USBַ
				s = USBHostTransact( USB_PID_IN << 4 | endp & 0x7F, endp & 0x80 ? bUH_R_TOG | bUH_T_TOG : 0, 0 );// CH554,ȡ,NAK
				if ( s == ERR_SUCCESS ){
					endp ^= 0x80;                                             // ͬ־ת  
					ThisUsbDev.GpVar[0] = endp;                               // ͬ־λ
					len = USB_RX_LEN;                                         // յݳ
					
					for ( i = 0; i < len; i ++ ){
						printf("x%02X ",(UINT16)(RxBuffer[i]) );
					}
					printf("\n");					
					if ( len ){
						
						memcpy(TxBuffer,RxBuffer,len);                         //ش
						endp = ThisUsbDev.GpVar[2];                            //´˵㷢OUT
						UH_TX_LEN = len; 
						s = USBHostTransact( USB_PID_OUT << 4 | endp & 0x7F, endp & 0x80 ? bUH_R_TOG | bUH_T_TOG : 0, 0xffff ); //޴´
						if(s == ERR_SUCCESS)
						{
							endp ^= 0x80;                                       // ͬ־ת  
							ThisUsbDev.GpVar[2] = endp;                         // ͬ־λ						
							printf("send back\n");
						}

					}
				}
				else if ( s != ( USB_PID_NAK | ERR_USB_TRANSFER ) ){
					printf("transmit error %02x\n",(UINT16)s);               // ǶϿ
				}					
			}					
			SetUsbSpeed( 1 );                                                // ĬΪȫ
		} 
		
			
    }
}
