
/********************************** (C) COPYRIGHT *******************************
* File Name          :CompositeKM.C
* Author             : WCH
* Version            : V1.2 
* Date               : 2018/02/28
* Description        : CH559ģUSB豸֧,ֻ֧
*******************************************************************************/

#include "./Public/CH554.H"                                                      
#include "./Public/Debug.H"
#include <string.h>
#include <stdio.h>

//#define Fullspeed
#define THIS_ENDP0_SIZE         DEFAULT_ENDP0_SIZE

UINT8X  Ep0Buffer[8>(THIS_ENDP0_SIZE+2)?8:(THIS_ENDP0_SIZE+2)] _at_ 0x0000;    //˵0 OUT&INżַ
UINT8X  Ep1Buffer[64>(MAX_PACKET_SIZE+2)?64:(MAX_PACKET_SIZE+2)] _at_ 0x000a;  //˵1 IN,żַ
UINT8X  Ep2Buffer[64>(MAX_PACKET_SIZE+2)?64:(MAX_PACKET_SIZE+2)] _at_ 0x0050;  //˵2 IN,żַ
UINT8   SetupReq,SetupLen,Ready,Count,FLAG,UsbConfig;
PUINT8  pDescr;                                                                //USBñ־
USB_SETUP_REQ   SetupReqBuf;                                                   //ݴSetup
sbit Ep2InKey = P1^5;
#define UsbSetupBuf     ((PUSB_SETUP_REQ)Ep0Buffer)
#define DEBUG 0
#pragma  NOAREGS
/*豸*/
UINT8C DevDesc[18] = {0x12,0x01,0x10,0x01,0x00,0x00,0x00,THIS_ENDP0_SIZE,
                      0x3d,0x41,0x07,0x21,0x00,0x00,0x00,0x00,
                      0x00,0x01
                     };
UINT8C CfgDesc[59] =
{
    0x09,0x02,0x3b,0x00,0x02,0x01,0x00,0xA0,0x32,             //
    0x09,0x04,0x00,0x00,0x01,0x03,0x01,0x01,0x00,             //ӿ,
    0x09,0x21,0x11,0x01,0x00,0x01,0x22,0x3e,0x00,             //HID
    0x07,0x05,0x81,0x03,0x08,0x00,0x0a,                       //˵
    0x09,0x04,0x01,0x00,0x01,0x03,0x01,0x02,0x00,             //ӿ,
    0x09,0x21,0x10,0x01,0x00,0x01,0x22,0x34,0x00,             //HID
    0x07,0x05,0x82,0x03,0x04,0x00,0x0a                        //˵
};
/*ַ*/
/*HID౨*/
UINT8C KeyRepDesc[62] =
{
    0x05,0x01,0x09,0x06,0xA1,0x01,0x05,0x07,
    0x19,0xe0,0x29,0xe7,0x15,0x00,0x25,0x01,
    0x75,0x01,0x95,0x08,0x81,0x02,0x95,0x01,
    0x75,0x08,0x81,0x01,0x95,0x03,0x75,0x01,
    0x05,0x08,0x19,0x01,0x29,0x03,0x91,0x02,
    0x95,0x05,0x75,0x01,0x91,0x01,0x95,0x06,
    0x75,0x08,0x26,0xff,0x00,0x05,0x07,0x19,
    0x00,0x29,0x91,0x81,0x00,0xC0
};
UINT8C MouseRepDesc[52] =
{
    0x05,0x01,0x09,0x02,0xA1,0x01,0x09,0x01,
    0xA1,0x00,0x05,0x09,0x19,0x01,0x29,0x03,
    0x15,0x00,0x25,0x01,0x75,0x01,0x95,0x03,
    0x81,0x02,0x75,0x05,0x95,0x01,0x81,0x01,
    0x05,0x01,0x09,0x30,0x09,0x31,0x09,0x38,
    0x15,0x81,0x25,0x7f,0x75,0x08,0x95,0x03,
    0x81,0x06,0xC0,0xC0
};
/**/
UINT8 HIDMouse[4] = {0x0,0x0,0x0,0x0};
/**/
UINT8 HIDKey[8] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0};

/*******************************************************************************
* Function Name  : CH554SoftReset()
* Description    : CH554λ
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void CH554SoftReset( )
{
    SAFE_MOD = 0x55;
    SAFE_MOD = 0xAA;
    GLOBAL_CFG	|=bSW_RESET;
}

/*******************************************************************************
* Function Name  : CH554USBDevWakeup()
* Description    : CH554豸ģʽKź
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void CH554USBDevWakeup( )
{
#ifdef Fullspeed
	UDEV_CTRL |= bUD_LOW_SPEED;
	mDelaymS(2);
	UDEV_CTRL &= ~bUD_LOW_SPEED;		
#else
	UDEV_CTRL &= ~bUD_LOW_SPEED;
	mDelaymS(2);
	UDEV_CTRL |= bUD_LOW_SPEED;	
#endif
}

/*******************************************************************************
* Function Name  : USBDeviceInit()
* Description    : USB豸ģʽ,豸ģʽշ˵ãжϿ
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void USBDeviceInit()
{
	IE_USB = 0;
	USB_CTRL = 0x00;                                                           // 趨USB豸ģʽ
	UDEV_CTRL = bUD_PD_DIS;                                                    // ֹDP/DM
#ifndef Fullspeed
    UDEV_CTRL |= bUD_LOW_SPEED;                                                //ѡ1.5Mģʽ
    USB_CTRL |= bUC_LOW_SPEED;
#else
    UDEV_CTRL &= ~bUD_LOW_SPEED;                                               //ѡȫ12MģʽĬϷʽ
    USB_CTRL &= ~bUC_LOW_SPEED;
#endif
	
    UEP2_DMA = Ep2Buffer;                                                      //˵2ݴַ
    UEP2_3_MOD = UEP2_3_MOD & ~bUEP2_BUF_MOD | bUEP2_TX_EN;                    //˵2ʹ 64ֽڻ
    UEP2_CTRL = bUEP_AUTO_TOG | UEP_T_RES_NAK;                                 //˵2Զתͬ־λIN񷵻NAK
    UEP0_DMA = Ep0Buffer;                                                      //˵0ݴַ
    UEP4_1_MOD &= ~(bUEP4_RX_EN | bUEP4_TX_EN);                                //˵064ֽշ
    UEP0_CTRL = UEP_R_RES_ACK | UEP_T_RES_NAK;                                 //OUT񷵻ACKIN񷵻NAK
    UEP1_DMA = Ep1Buffer;                                                      //˵1ݴַ
    UEP4_1_MOD = UEP4_1_MOD & ~bUEP1_BUF_MOD | bUEP1_TX_EN;                    //˵1ʹ 64ֽڻ
    UEP1_CTRL = bUEP_AUTO_TOG | UEP_T_RES_NAK;                                 //˵1Զתͬ־λIN񷵻NAK	
		
	USB_DEV_AD = 0x00;
	USB_CTRL |= bUC_DEV_PU_EN | bUC_INT_BUSY | bUC_DMA_EN;                      // USB豸DMAжڼжϱ־δǰԶNAK
	UDEV_CTRL |= bUD_PORT_EN;                                                  // USB˿
	USB_INT_FG = 0xFF;                                                         // жϱ־
	USB_INT_EN = bUIE_SUSPEND | bUIE_TRANSFER | bUIE_BUS_RST;
	IE_USB = 1;
}
/*******************************************************************************
* Function Name  : Enp1IntIn()
* Description    : USB豸ģʽ˵1жϴ
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void Enp1IntIn( )
{
    memcpy( Ep1Buffer, HIDKey, sizeof(HIDKey));                              //ϴ
    UEP1_T_LEN = sizeof(HIDKey);                                             //ϴݳ
    UEP1_CTRL = UEP1_CTRL & ~ MASK_UEP_T_RES | UEP_T_RES_ACK;                //ʱϴݲӦACK
}
/*******************************************************************************
* Function Name  : Enp2IntIn()
* Description    : USB豸ģʽ˵2жϴ
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void Enp2IntIn( )
{
    memcpy( Ep2Buffer, HIDMouse, sizeof(HIDMouse));                              //ϴ
    UEP2_T_LEN = sizeof(HIDMouse);                                              //ϴݳ
    UEP2_CTRL = UEP2_CTRL & ~ MASK_UEP_T_RES | UEP_T_RES_ACK;                  //ʱϴݲӦACK
}
/*******************************************************************************
* Function Name  : DeviceInterrupt()
* Description    : CH559USBжϴ
*******************************************************************************/
void    DeviceInterrupt( void ) interrupt INT_NO_USB using 1                      //USBжϷ,ʹüĴ1
{
    UINT8 len = 0;
    if(UIF_TRANSFER)                                                            //USBɱ־
    {
        switch (USB_INT_ST & (MASK_UIS_TOKEN | MASK_UIS_ENDP))
        {
        case UIS_TOKEN_IN | 2:                                                  //endpoint 2# ж϶˵ϴ
            UEP2_T_LEN = 0;                                                     //Ԥʹ÷ͳһҪ
//            UEP1_CTRL ^= bUEP_T_TOG;                                          //ԶתҪֶת
            UEP2_CTRL = UEP2_CTRL & ~ MASK_UEP_T_RES | UEP_T_RES_NAK;           //ĬӦNAK
            break;
        case UIS_TOKEN_IN | 1:                                                  //endpoint 1# ж϶˵ϴ
            UEP1_T_LEN = 0;                                                     //Ԥʹ÷ͳһҪ
//            UEP2_CTRL ^= bUEP_T_TOG;                                          //ԶתҪֶת
            UEP1_CTRL = UEP1_CTRL & ~ MASK_UEP_T_RES | UEP_T_RES_NAK;           //ĬӦNAK
            FLAG = 1;                                                           /*ɱ־*/
            break;
        case UIS_TOKEN_SETUP | 0:                                                //SETUP
            len = USB_RX_LEN;
            if(len == (sizeof(USB_SETUP_REQ)))
            {
                SetupLen = UsbSetupBuf->wLengthL;
                if(UsbSetupBuf->wLengthH || SetupLen > 0x7F )
                {
                    SetupLen = 0x7F;    // ܳ
                }
                len = 0;                                                        // ĬΪɹϴ0
                SetupReq = UsbSetupBuf->bRequest;								
                if ( ( UsbSetupBuf->bRequestType & USB_REQ_TYP_MASK ) != USB_REQ_TYP_STANDARD )/* HID */
                {
					switch( SetupReq ) 
					{
						case 0x01://GetReport
							break;
						case 0x02://GetIdle
							break;	
						case 0x03://GetProtocol
							break;				
						case 0x09://SetReport										
							break;
						case 0x0A://SetIdle
							break;	
						case 0x0B://SetProtocol
							break;
						default:
							len = 0xFF;  								   /*֧*/					
							break;
					}	
                }
                else
                {                                                           //׼
                    switch(SetupReq)                                        //
                    {
                    case USB_GET_DESCRIPTOR:
                        switch(UsbSetupBuf->wValueH)
                        {
                        case 1:                                             //豸
                            pDescr = DevDesc;                               //豸͵Ҫ͵Ļ
                            len = sizeof(DevDesc);
                            break;
                        case 2:                                             //
                            pDescr = CfgDesc;                               //豸͵Ҫ͵Ļ
                            len = sizeof(CfgDesc);
                            break;
                        case 0x22:                                          //
                            if(UsbSetupBuf->wIndexL == 0)                   //ӿ0
                            {
                                pDescr = KeyRepDesc;                        //׼ϴ
                                len = sizeof(KeyRepDesc);
                            }
                            else if(UsbSetupBuf->wIndexL == 1)              //ӿ1
                            {
                                pDescr = MouseRepDesc;                      //׼ϴ
                                len = sizeof(MouseRepDesc);                                
                            }
                            else
                            {
                                len = 0xff;                                 //ֻ2ӿڣ仰ִ
                            }
                            break;
                        default:
                            len = 0xff;                                     //ֵ֧߳
                            break;
                        }
                        if ( SetupLen > len )
                        {
                            SetupLen = len;    //ܳ
                        }
                        len = SetupLen >= THIS_ENDP0_SIZE ? THIS_ENDP0_SIZE : SetupLen; //δ䳤
                        memcpy(Ep0Buffer,pDescr,len);                        //ϴ
                        SetupLen -= len;
                        pDescr += len;
                        break;
                    case USB_SET_ADDRESS:
                        SetupLen = UsbSetupBuf->wValueL;                     //ݴUSB豸ַ
                        break;
                    case USB_GET_CONFIGURATION:
                        Ep0Buffer[0] = UsbConfig;
                        if ( SetupLen >= 1 )
                        {
                            len = 1;
                        }
                        break;
                    case USB_SET_CONFIGURATION:
                        UsbConfig = UsbSetupBuf->wValueL;
						if(UsbConfig)
						{
#ifdef DE_PRINTF 							
							printf("SET CONFIG.\n");
#endif
							Ready = 1;                                      //set configһusböɵı־
						}
						break;
                    case 0x0A:
                        break;
                    case USB_CLEAR_FEATURE:                                            //Clear Feature
                        if ( ( UsbSetupBuf->bRequestType & USB_REQ_RECIP_MASK ) == USB_REQ_RECIP_ENDP )// ˵
                        {
                            switch( UsbSetupBuf->wIndexL )
                            {
                            case 0x82:
                                UEP2_CTRL = UEP2_CTRL & ~ ( bUEP_T_TOG | MASK_UEP_T_RES ) | UEP_T_RES_NAK;
                                break;
                            case 0x81:
                                UEP1_CTRL = UEP1_CTRL & ~ ( bUEP_T_TOG | MASK_UEP_T_RES ) | UEP_T_RES_NAK;
                                break;
                            case 0x01:
                                UEP1_CTRL = UEP1_CTRL & ~ ( bUEP_R_TOG | MASK_UEP_R_RES ) | UEP_R_RES_ACK;
                                break;
                            default:
                                len = 0xFF;                                            // ֵ֧Ķ˵
                                break;
                            }
                        }
                        if ( ( UsbSetupBuf->bRequestType & USB_REQ_RECIP_MASK ) == USB_REQ_RECIP_DEVICE )// 豸
                        {
							break;
                        }													
                        else
                        {
                            len = 0xFF;                                                // Ƕ˵㲻֧
                        }
                        break;
                    case USB_SET_FEATURE:                                              /* Set Feature */
                        if( ( UsbSetupBuf->bRequestType & 0x1F ) == 0x00 )             /* 豸 */
                        {
                            if( ( ( ( UINT16 )UsbSetupBuf->wValueH << 8 ) | UsbSetupBuf->wValueL ) == 0x01 )
                            {
                                if( CfgDesc[ 7 ] & 0x20 )
                                {
                                    /* ûʹܱ־ */
                                }
                                else
                                {
                                    len = 0xFF;                                        /* ʧ */
                                }
                            }
                            else
                            {
                                len = 0xFF;                                            /* ʧ */
                            }
                        }
                        else if( ( UsbSetupBuf->bRequestType & 0x1F ) == 0x02 )        /* ö˵ */
                        {
                            if( ( ( ( UINT16 )UsbSetupBuf->wValueH << 8 ) | UsbSetupBuf->wValueL ) == 0x00 )
                            {
                                switch( ( ( UINT16 )UsbSetupBuf->wIndexH << 8 ) | UsbSetupBuf->wIndexL )
                                {
                                case 0x82:
                                    UEP2_CTRL = UEP2_CTRL & (~bUEP_T_TOG) | UEP_T_RES_STALL;/* ö˵2 IN STALL */
                                    break;
                                case 0x02:
                                    UEP2_CTRL = UEP2_CTRL & (~bUEP_R_TOG) | UEP_R_RES_STALL;/* ö˵2 OUT Stall */
                                    break;
                                case 0x81:
                                    UEP1_CTRL = UEP1_CTRL & (~bUEP_T_TOG) | UEP_T_RES_STALL;/* ö˵1 IN STALL */
                                    break;
                                default:
                                    len = 0xFF;                               //ʧ
                                    break;
                                }
                            }
                            else
                            {
                                len = 0xFF;                                   //ʧ
                            }
                        }
                        else
                        {
                            len = 0xFF;                                      //ʧ
                        }
                        break;
                    case USB_GET_STATUS:
                        Ep0Buffer[0] = 0x00;
                        Ep0Buffer[1] = 0x00;
                        if ( SetupLen >= 2 )
                        {
                            len = 2;
                        }
                        else
                        {
                            len = SetupLen;
                        }
                        break;
                    default:
                        len = 0xff;                                           //ʧ
                        break;
                    }
                }
            }
            else
            {
                len = 0xff;                                                   //ȴ
            }
            if(len == 0xff)
            {
                SetupReq = 0xFF;
                UEP0_CTRL = bUEP_R_TOG | bUEP_T_TOG | UEP_R_RES_STALL | UEP_T_RES_STALL;//STALL
            }
            else if(len)                                                //ϴݻ״̬׶η0Ȱ
            {
                UEP0_T_LEN = len;
                UEP0_CTRL = bUEP_R_TOG | bUEP_T_TOG | UEP_R_RES_ACK | UEP_T_RES_ACK;//ĬݰDATA1ӦACK
            }
            else
            {
                UEP0_T_LEN = 0;  //Ȼδ״̬׶ΣǰԤϴ0ݰԷǰ״̬׶
                UEP0_CTRL = bUEP_R_TOG | bUEP_T_TOG | UEP_R_RES_ACK | UEP_T_RES_ACK;//ĬݰDATA1,ӦACK
            }
            break;
        case UIS_TOKEN_IN | 0:                                               //endpoint0 IN
            switch(SetupReq)
            {
            case USB_GET_DESCRIPTOR:
                len = SetupLen >= THIS_ENDP0_SIZE ? THIS_ENDP0_SIZE : SetupLen;    //δ䳤
                memcpy( Ep0Buffer, pDescr, len );                            //ϴ
                SetupLen -= len;
                pDescr += len;
                UEP0_T_LEN = len;
                UEP0_CTRL ^= bUEP_T_TOG;                                     //ͬ־λת
                break;
            case USB_SET_ADDRESS:
                USB_DEV_AD = USB_DEV_AD & bUDA_GP_BIT | SetupLen;
                UEP0_CTRL = UEP_R_RES_ACK | UEP_T_RES_NAK;
                break;
            default:
                UEP0_T_LEN = 0;                                              //״̬׶жϻǿϴ0ݰƴ
                UEP0_CTRL = UEP_R_RES_ACK | UEP_T_RES_NAK;
                break;
            }
            break;
        case UIS_TOKEN_OUT | 0:  // endpoint0 OUT
            len = USB_RX_LEN;
            if(SetupReq == 0x09)
            {
                if(Ep0Buffer[0])
                {
                    printf("Light on Num Lock LED!\n");
                }
                else if(Ep0Buffer[0] == 0)
                {
                    printf("Light off Num Lock LED!\n");
                }				
            }
            UEP0_CTRL ^= bUEP_R_TOG;                                     //ͬ־λת						
            break;
        default:
            break;
        }
        UIF_TRANSFER = 0;                                                 //д0ж
    }
    if(UIF_BUS_RST)                                                       //豸ģʽUSB߸λж
    {
        UEP0_CTRL = UEP_R_RES_ACK | UEP_T_RES_NAK;
        UEP1_CTRL = bUEP_AUTO_TOG | UEP_R_RES_ACK;
        UEP2_CTRL = bUEP_AUTO_TOG | UEP_R_RES_ACK | UEP_T_RES_NAK;
        USB_DEV_AD = 0x00;
        UIF_SUSPEND = 0;
        UIF_TRANSFER = 0;
        UIF_BUS_RST = 0;                                                 //жϱ־
    }
    if (UIF_SUSPEND)                                                     //USB߹/
    {
        UIF_SUSPEND = 0;
        if ( USB_MIS_ST & bUMS_SUSPEND )                                 //
        {
#if DEBUG
            printf( "zz" );                                              //˯״̬
#endif
//             while ( XBUS_AUX & bUART0_TX );                              //ȴ
//             SAFE_MOD = 0x55;
//             SAFE_MOD = 0xAA;
//             WAKE_CTRL = bWAK_BY_USB | bWAK_RXD0_LO;                      //USBRXD0źʱɱ
//             PCON |= PD;                                                  //˯
//             SAFE_MOD = 0x55;
//             SAFE_MOD = 0xAA;
//             WAKE_CTRL = 0x00;
        }
    }
    else {                                                               //ж,ܷ
        USB_INT_FG = 0xFF;                                               //жϱ־
//      printf("UnknownInt  N");
    }
}
void HIDValueHandle()
{
    UINT8 i;
        i = getkey( );
        printf( "%c", (UINT8)i );
        switch(i)
        {
//ϴʾ
        case 'L':                                                        //
            HIDMouse[0] = 0x01;
            Enp2IntIn();
            HIDMouse[0] = 0;
            break;
        case 'R':                                                        //Ҽ
            HIDMouse[0] = 0x02;
            Enp2IntIn();
            HIDMouse[0] = 0;
            break;
//ϴʾ
        case 'A':                                                         //A
            FLAG = 0;
            HIDKey[2] = 0x1d;                                             //ʼ
            Enp1IntIn();
            HIDKey[2] = 0;                                                //
            while(FLAG == 0)
            {
                ;    /*ȴһ*/
            }
            Enp1IntIn();
            break;
        case 'P':                                                         //P
            FLAG = 0;
            HIDKey[2] = 0x38;
            Enp1IntIn();
            HIDKey[2] = 0;                                                //
            while(FLAG == 0)
            {
                ;    /*ȴһ*/
            }
            Enp1IntIn();
            break;
        case 'Q':                                                         //Num Lock
            FLAG = 0;
            HIDKey[2] = 0x39;
            Enp1IntIn();
            HIDKey[2] = 0;                                                //
            while(FLAG == 0)
            {
                ;    /*ȴһ*/
            }
            Enp1IntIn();
            break;
        default:                                                          //
            UEP1_CTRL = UEP1_CTRL & ~ MASK_UEP_T_RES | UEP_T_RES_NAK;     //ĬӦNAK
            UEP2_CTRL = UEP2_CTRL & ~ MASK_UEP_T_RES | UEP_T_RES_NAK;     //ĬӦNAK
            break;
        }
}

main()
{
    CfgFsys( );                                                           //CH559ʱѡ
    mDelaymS(5);                                                          //޸Ƶȴڲȶ,ؼ	
    mInitSTDIO( );                                                        //0ʼ
#ifdef DE_PRINTF
    printf("start ...\n");
#endif
	
#ifdef DE_PRINTF                                                          //ȡоƬΨһID
	printf("ID0 = %02x %02x \n",(UINT16)*(PUINT8C)(0x3FFA),(UINT16)*(PUINT8C)(0x3FFB));
	printf("ID1 = %02x %02x \n",(UINT16)*(PUINT8C)(0x3FFC),(UINT16)*(PUINT8C)(0x3FFD));
	printf("ID2 = %02x %02x \n",(UINT16)*(PUINT8C)(0x3FFE),(UINT16)*(PUINT8C)(0x3FFF));
#endif
	
    USBDeviceInit();                                                      //USB豸ģʽʼ
    EA = 1;                                                               //Ƭж
    UEP1_T_LEN = 0;                                                       //Ԥʹ÷ͳһҪ
    UEP2_T_LEN = 0;                                                       //Ԥʹ÷ͳһҪ
    FLAG = 0;
    Ready = 0;
    while(1)
    {
        if(Ready)
        {
            HIDValueHandle();                                             //úһֱȴڽһֽ
        }
		
        if((Ready)&&(Ep2InKey == 0)){ 	   													
			Enp1IntIn( );                                                   //ͼֵ̧̼𡱲
			mDelaymS( 10 );			
        }
        mDelaymS( 100 );                                                   //ģⵥƬ
    }
}
