
/********************************** (C) COPYRIGHT *******************************
* File Name          : UART1.C
* Author             : WCH
* Version            : V1.0
* Date               : 2018/07/25
* Description        : CH554 1շ  
*******************************************************************************/

#include "..\Public\CH554.H"                                                          
#include "..\Public\Debug.H"
#include "UART1.H"
#include "stdio.h"

#pragma  NOAREGS

/*******************************************************************************
* Function Name  : UART1Setup()
* Description    : CH5541ʼ
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void UART1Init( )
{
	U1SM0 = 0;                                                                   //UART1ѡ8λλ
	U1SMOD = 1;                                                                  //ģʽ
	U1REN = 1;                                                                   //ʹܽ
	SBAUD1 = 0 - FREQ_SYS/16/UART1_BUAD;
	U1TI = 0;
#if UART1_PINMAP	
    PIN_FUNC |= bUART1_PIN_X;                                                   //ӳ䵽P34(R)P32(T)
#endif

#if UART1_INTERRUPT                                                            //жʹ
	IE_UART1 = 1;	
	EA = 1;
#endif	
}
/*******************************************************************************
* Function Name  : CH554UART1RcvByte()
* Description    : CH554UART1һֽ
* Input          : None
* Output         : None
* Return         : SBUF
*******************************************************************************/
UINT8  CH554UART1RcvByte( )
{
    while(U1RI == 0);                                                           //ѯգжϷʽɲ
    U1RI = 0;
    return SBUF1;
}

/*******************************************************************************
* Function Name  : CH554UART1SendByte(UINT8 SendDat)
* Description    : CH554UART1һֽ
* Input          : UINT8 SendDatҪ͵
* Output         : None
* Return         : None
*******************************************************************************/
void CH554UART1SendByte(UINT8 SendDat)
{
	SBUF1 = SendDat;                                                             //ѯͣжϷʽɲ2,ǰTI=0
	while(U1TI ==0);
	U1TI = 0;
}


#if UART1_INTERRUPT
/*******************************************************************************
* Function Name  : UART1Interrupt(void)
* Description    : UART1 жϷ
*******************************************************************************/
void UART1Interrupt( void ) interrupt INT_NO_UART1 using 1                       //1жϷ,ʹüĴ1
{
	UINT8 dat;
	if(U1RI)
	{
		dat = SBUF1;
		U1RI = 0;
		
		CH554UART1SendByte(dat);
	}
}
#endif

