
/********************************** (C) COPYRIGHT *******************************
* File Name          : Type_C.C
* Author             : WCH
* Version            : V1.1
* Date               : 2017/07/05
* Description        : CH554 Type-Cʹ
                       ģʽ 豸⡢֪ͨ豸
                       ģʽ 	 
*******************************************************************************/

#include "..\Public\CH554.H"                                                         
#include "..\Public\Debug.H"
#include "Type_C.H"
#include "stdio.h"

#pragma  NOAREGS
/********************************************************************************
DFP (Downstream Facing Port) Host
UFP (Upstream Facing Port)   Dev

DFPCC pinRp,UFPRd
DFPUFPδǰ,DFPVBUSû

CC PIN壬DPFCC1ӵ;CC2ӵǷ壻
	 ֮󣬾ͻӦUSBź
	 
DPFڲͬģʽ£CC PINҪĵҪöRpֵ
********************************************************************************/
#ifdef TYPE_C_DFP

/*******************************************************************************
* Function Name  : TypeC_DFP_Init(UINT8 Power)
* Description    : Type-C UPFʼ
* Input          : UINT8 Power
                   0 ֹUCC1&2
                   1 Ĭϵ
                   2 1.5A
                   3 3.0A									 
* Output         : None
* Return         : NONE
*******************************************************************************/
void TypeC_DFP_Init( UINT8 Power )
{
   P1_MOD_OC &= ~(bUCC2|bUCC1);                                                   
   P1_DIR_PU &= ~(bUCC2|bUCC1);                                                   //UCC1 UCC2 ø
   if(Power == 0){
     DFP_DisableRpUCC1();                                                         //UCC1ֹ
     DFP_DisableRpUCC2();	                                                        //UCC2ֹ	
   }
	 else if(Power == 1){
     DFP_DefaultPowerUCC1();                                                      //Ĭ
     DFP_DefaultPowerUCC2();	                                                    	 
   }
   else if(Power == 2){
     DFP_1_5APowerUCC1();                                                         //1.5A
     DFP_1_5APowerUCC2();		 
   }
   else if(Power == 3){
     DFP_3_0APowerUCC1();                                                         //3.0A
     DFP_3_0APowerUCC2();		 
   }
   ADC_CFG = ADC_CFG & ~bADC_CLK | bADC_EN;											                  //ADCʱ,0(96clk) 1(384clk),ADCģ鿪	
	 P1_DIR_PU &= ~(bAIN0 | bAIN1);																									//UCC1UCC2ΪADC
   mDelayuS(2);                                                                   //ȴȫرպADCԴȶ	

}

/*******************************************************************************
* Function Name  : TypeC_DFP_Channle(void)
* Description    : Type-C DPFUFP壬ԼδѲ
* Input          : NONE
* Output         : None
* Return         : 0   δ
                   1   
                   2   
                   3   ӣ޷ж
*******************************************************************************/
UINT8 TypeC_DFP_Insert( void )
{
		UINT8 UCC1_Value,UCC2_Value;

    ADC_CHAN1 =0;ADC_CHAN0=1;                                                     //UCC1ͨADC
		mDelayuS(1);                                                                  //ͨлʱ	
		ADC_START = 1;                                                                //ʼ
		while(ADC_START);                                                             //ADC_START
		UCC1_Value = ADC_DATA;
//printf("UCC1_Value=%02x\n",(UINT16)UCC1_Value);  

    ADC_CHAN1 =1;ADC_CHAN0=0;                                                     //UCC2ͨADC
		mDelayuS(1);                                                                  //ͨлʱ	
		ADC_START = 1;                                                                //ʼ
		while(ADC_START);                                                             //ADC_START
		UCC2_Value = ADC_DATA;
//printf("UCC2_Value=%02x\n",(UINT16)UCC2_Value);                                                                                
		if( UCC1_Value<=UCC_Connect_Vlaue && UCC2_Value<=UCC_Connect_Vlaue )          //˫
    {	 
			return UCC_CONNECT;
		}
		else if( UCC1_Value<=UCC_Connect_Vlaue && UCC2_Value>=UCC_Connect_Vlaue )     //
    { 
			return UCC1_CONNECT;
		}
		else if( UCC1_Value>=UCC_Connect_Vlaue && UCC2_Value<=UCC_Connect_Vlaue )     //
    {	 
			return UCC2_CONNECT;
		}
		else if( UCC1_Value>=UCC_Connect_Vlaue && UCC2_Value>=UCC_Connect_Vlaue )     //δ
    {  
			return UCC_DISCONNECT;
		}
	  return UCC_DISCONNECT;
}
#endif

/********************************************************************************
UPF,ҪCCܽŵĵѹֵȡDFPĵ
--------  CCѹMin   CCѹMax
Ĭϵ   0.25V         0.61V
1.5A       0.70V         1.16V
3.0A       1.31V         2.04V
********************************************************************************/
#ifdef TYPE_C_UFP
/*******************************************************************************
* Function Name  : TypeC_UPF_PDInit()
* Description    : Type-C UPFʼ
* Input          : None
* Output         : None
* Return         : None							 
*******************************************************************************/
void TypeC_UPF_PDInit( void )
{
   P1_MOD_OC &= ~(bUCC2|bUCC1);                                                   
   P1_DIR_PU &= ~(bUCC2|bUCC1);                                                   //UCC1 UCC2 ø
	 UPF_DisableRd(1);                                                              //UCC
   ADC_CFG = ADC_CFG & ~bADC_CLK | bADC_EN;											                  //ADCʱ,0(96clk) 1(384clk),ADCģ鿪	
	 P1_DIR_PU &= ~(bAIN0 | bAIN1);																									//UCC1UCC2ΪADC
   mDelayuS(2);                                                                   //ȴȫرպADCԴȶ	
}

/*******************************************************************************
* Function Name  : TypeC_UPF_PDCheck()
* Description    : Type-C UPFDPF
* Input          : None
* Output         : None
* Return         : UINT8 RE  
                   0  defaultPower
                   1  1.5A
                   2  3.0A	
                   0xff 									 
*******************************************************************************/
UINT8 TypeC_UPF_PDCheck()
{
		UINT8 ADC_VALUE;
	
		ADC_CHAN1 =0;ADC_CHAN0=1;
		mDelayuS(2);                                                                  //ͨлʱ	
	  ADC_START = 1;                                                                //ʼ
    while(ADC_START);                                                             //ADC_STARTΪ0ʱʾ
		ADC_VALUE = ADC_DATA;
	  if((ADC_VALUE >= Power3_0AMin)&&(ADC_VALUE <= Power3_0AMax))
    {
      return UPF_PD_3A;                                                           //3.0A			
    }
    else if((ADC_VALUE >= Power1_5AMin)&&(ADC_VALUE <= Power1_5AMax))
    {
      return UPF_PD_1A5;                                                          //1.5A			
    }		
    else if((ADC_VALUE >= DufaultPowerMin)&&(ADC_VALUE <= DufaultPowerMax))
    {
      return UPF_PD_Normal;                                                       //ĬϹ			
    }		
		
    ADC_CHAN1 =1;ADC_CHAN0=0;
    mDelayuS(2);                                                                  //ͨлʱ	
    ADC_START = 1;                                                                //ʼɽж	
    while(ADC_START);                                                             //ADC_STARTΪ0ʱʾ
		ADC_VALUE = ADC_DATA;
		
    if((ADC_VALUE >= Power3_0AMin)&&(ADC_VALUE <= Power3_0AMax))
    {
      return UPF_PD_3A;                                                           //3.0A			
    }
    else if((ADC_VALUE >= Power1_5AMin)&&(ADC_VALUE <= Power1_5AMax))
    {
      return UPF_PD_1A5;                                                          //1.5A			
    }		
    else if((ADC_VALUE >= DufaultPowerMin)&&(ADC_VALUE <= DufaultPowerMax))
    {
      return UPF_PD_Normal;                                                       //ĬϹ			
    }	
    return UPD_PD_DISCONNECT;		
}
#endif
