
/********************************** (C) COPYRIGHT *******************************
* File Name          : Timer.C
* Author             : WCH
* Version            : V1.0
* Date               : 2017/01/20
* Description        : CH554 Time ʼʱֵT2׽ܿ
                       ʱжϺ          		 		   
*******************************************************************************/
#include "..\Public\CH554.H"                                                  
#include "..\Public\Debug.H"
#include "Timer.H" 
#include "stdio.h"

#pragma  NOAREGS

/*******************************************************************************
* Function Name  : mTimer_x_ModInit(UINT8 x ,UINT8 mode)
* Description    : CH554ʱxģʽ
* Input          : UINT8 mode,Timerģʽѡ
                   0ģʽ013λʱTLnĸ3λЧ
                   1ģʽ116λʱ
                   2ģʽ28λԶװʱ
                   3ģʽ38λʱ  Timer0
                   3ģʽ3Timer1ֹͣ									 
* Output         : None
* Return         : ɹ  SUCCESS
                   ʧ  FAIL
*******************************************************************************/
UINT8 mTimer_x_ModInit(UINT8 x ,UINT8 mode)
{
    if(x == 0){TMOD = TMOD & 0xf0 | mode;}
    else if(x == 1){TMOD = TMOD & 0x0f | (mode<<4);}
    else if(x == 2){RCLK = 0;TCLK = 0;CP_RL2 = 0;}                               //16λԶضʱ
    else return FAIL;
    return SUCCESS;
}

/*******************************************************************************
* Function Name  : mTimer_x_SetData(UINT8 x,UINT16 dat)
* Description    : CH554Timer0 TH0TL0ֵ
* Input          : UINT16 dat;ʱֵ
* Output         : None
* Return         : None
*******************************************************************************/
void mTimer_x_SetData(UINT8 x,UINT16 dat)
{
    UINT16 tmp;
    tmp = 65536 - dat;	
		if(x == 0){TL0 = tmp & 0xff;TH0 = (tmp>>8) & 0xff;}
		else if(x == 1){TL1 = tmp & 0xff;TH1 = (tmp>>8) & 0xff;}
		else if(x == 2){
      RCAP2L = TL2 = tmp & 0xff;                                               //16λԶضʱ
      RCAP2H = TH2 = (tmp>>8) & 0xff;
    }                                                 
}

/*******************************************************************************
* Function Name  : CAP2Init(UINT8 mode)
* Description    : CH554ʱ2 T2EXŲ׽ܳʼ
                   UINT8 mode,ز׽ģʽѡ
                   0:T2ex½صһ½
                   1:T2ex֮
                   3:T2exصһ
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void CAP2Init(UINT8 mode)
{
    RCLK = 0;
    TCLK = 0;	
    C_T2  = 0;
    EXEN2 = 1; 
    CP_RL2 = 1;                                                                //T2exĲ׽
    T2MOD |= mode << 2;                                                        //ز׽ģʽѡ
}

/*******************************************************************************
* Function Name  : CAP1Init(UINT8 mode)
* Description    : CH554ʱ2 T2Ų׽ܳʼT2
                   UINT8 mode,ز׽ģʽѡ
                   0:T2ex½صһ½
                   1:T2ex֮
                   3:T2exصһ
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void CAP1Init(UINT8 mode)
{
    RCLK = 0;
    TCLK = 0;
    CP_RL2 = 1;
    C_T2 = 0;
    T2MOD = T2MOD & ~T2OE | (mode << 2) | bT2_CAP1_EN;                         //ʹT2Ų׽,ز׽ģʽѡ
}

#ifdef T0_INT
/*******************************************************************************
* Function Name  : mTimer0Interrupt()
* Description    : CH554ʱ0ʱжϴ
*******************************************************************************/
void	mTimer0Interrupt( void ) interrupt INT_NO_TMR0 using 1                //timer0жϷ,ʹüĴ1
{                                                                           //ʽ3ʱTH0ʹTimer1жԴ
    SCK = ~SCK;
//     mTimer_x_SetData(0,0x0000);                                          //Զطʽ¸TH0TL0ֵ      
}
#endif

#ifdef T1_INT
/*******************************************************************************
* Function Name  : mTimer1Interrupt()
* Description    : CH554ʱ0ʱжϴ
*******************************************************************************/
void	mTimer1Interrupt( void ) interrupt INT_NO_TMR1 using 2                //timer1жϷ,ʹüĴ2
{                                                                           //ʽ3ʱTimer1ֹͣ
    SCK = ~SCK;
//     mTimer_x_SetData(1,0x0000);                                          //Զطʽ¸TH1TL1ֵ      
}
#endif

#ifdef T2_INT
/*******************************************************************************
* Function Name  : mTimer2Interrupt()
* Description    : CH554ʱ0ʱжϴ
*******************************************************************************/
void	mTimer2Interrupt( void ) interrupt INT_NO_TMR2 using 3                //timer2жϷ,ʹüĴ3
{                                                                             
    mTimer2RunCTL( 0 );                                                     //ضʱ
#ifdef  T2_CAP   
    if(EXF2)                                                                //T2exƽ仯жжϱ־
    {
        SCK = ~SCK;                                                         //P17ƽָʾ
        Cap[FLAG++] = RCAP2;                                                //T2EX
        printf("RCAP2 %04x  \n",RCAP2);                                  			
        EXF2 = 0;                                                           //T2ex׽жϱ־		
    }
    if(CAP1F)                                                               //T2ƽ׽жϱ־
    {
        Cap[FLAG++] = T2CAP1;                                               //T2;	  	
        printf("T2CAP1 %04x  \n",T2CAP1);				
        CAP1F = 0;                                                          //T2׽жϱ־
    }
#endif	
    if(TF2)
    {
        TF2 = 0;                                                             //նʱ2ж	                                                      
        SCK = ~SCK;                                                          //P17ƽָʾ
    }
    mTimer2RunCTL( 1 );                                                      //ʱ   
}
#endif
