
/********************************** (C) COPYRIGHT *******************************
* File Name          : SPI.C
* Author             : WCH
* Version            : V1.0
* Date               : 2017/07/05
* Description        : CH554 SPIģʽӿں
עƬѡЧʱӻԶSPI0_S_PREԤֵλÿƬѡ
ЧǰSPI0_S_PREĴдԤֵ˶׸ֽڣʱע 
ȡSPI0_S_PREֵһS0_IF_BYTEжϡ
ƬѡЧЧӻȽз͵ĻðֽڷŵSPI0_S_PREĴУ
ѾƬѡЧĻʹSPI0_DATAͿ
*******************************************************************************/

#include "..\Public\CH554.H"                                                          //Ϣӡ
#include "..\Public\Debug.H"
#include "SPI.H" 

#pragma  NOAREGS

/*******************************************************************************
* Function Name  : SPIMasterModeSet( UINT8 mode ) 
* Description    : SPIģʽʼ
* Input          : UINT8 mode						 
* Output         : None
* Return         : None
*******************************************************************************/
void SPIMasterModeSet(UINT8 mode)
{
    SPI0_SETUP = 0;                                                           //Masterģʽ,λǰ
    if(mode == 0){
      SPI0_CTRL = 0x60;                                                       //ģʽ0			
    }			
    else if(mode == 3){
      SPI0_CTRL = 0x68;                                                       //ģʽ3
    }			
    P1_MOD_OC |= 0xFF;
    P1_DIR_PU |= 0xFF;                                                        //SCS,MOSI,SCK
}

/*******************************************************************************
* Function Name  : CH554SPIInterruptInit()
* Description    : CH554SPIжϳʼ
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void CH554SPIInterruptInit()
{
    //IP_EX |= bIP_SPI0;                                                       //SPI0жȼ
    SPI0_SETUP |= bS0_IE_FIFO_OV | bS0_IE_BYTE;                                //ʹܽ1ֽжϣʹFIFOж
    SPI0_CTRL |= bS0_AUTO_IF;                                                  //ԶS0_IF_BYTEжϱ־
    SPI0_STAT |= 0xff;                                                         //SPI0жϱ־
#ifdef SPI_Interrupt
    IE_SPI0 = 1;                                                               //ʹSPI0ж
#endif
}

/*******************************************************************************
* Function Name  : CH554SPIMasterWrite(UINT8 dat)
* Description    : CH554ӲSPIд,ģʽ
* Input          : UINT8 dat   
* Output         : None
* Return         : None
*******************************************************************************/
void CH554SPIMasterWrite(UINT8 dat)
{
    SPI0_DATA = dat;                                                           
    while(S0_FREE == 0);													   //ȴ		
//bS0_DATA_DIRΪ1˴ֱӶȡһֽڵڿٶд	
}

/*******************************************************************************
* Function Name  : CH554SPIMasterRead( )
* Description    : CH554ӲSPI0ݣģʽ
* Input          : None
* Output         : None
* Return         : UINT8 ret   
*******************************************************************************/
UINT8 CH554SPIMasterRead()
{
    SPI0_DATA = 0xff;
    while(S0_FREE == 0);
    return SPI0_DATA;
}

/*******************************************************************************
* Function Name  : SPISlvModeSet( ) 
* Description    : SPIӻģʽʼ
* Input          : None						 
* Output         : None
* Return         : None
*******************************************************************************/
void SPISlvModeSet( )
{
    SPI0_SETUP = 0x80;                                                        //Slvģʽ,λǰ
    SPI0_CTRL = 0x89;                                                         //дFIFO,ԶS0_IF_BYTE־
    P1_MOD_OC &= 0x0F;
    P1_DIR_PU &= 0x0F;                                                        //SCS,MOSI,SCK,MISOȫø
}

/*******************************************************************************
* Function Name  : CH554SPISlvWrite(UINT8 dat)
* Description    : CH554ӲSPIдݣӻģʽ
* Input          : UINT8 dat   
* Output         : None
* Return         : None
*******************************************************************************/
void CH554SPISlvWrite(UINT8 dat)
{
    SPI0_DATA = dat;
    while(S0_FREE==0);		                                                     
}

/*******************************************************************************
* Function Name  : CH554SPISlvRead( )
* Description    : CH554ӲSPI0ݣӻģʽ
* Input          : None
* Output         : None
* Return         : UINT8 ret   
*******************************************************************************/
UINT8 CH554SPISlvRead()
{
    while(S0_FREE == 0);
    return SPI0_DATA;
}

#if SPI_Interrupt
/*******************************************************************************
* Function Name  : SPIInterrupt(void)
* Description    : SPI жϷ
*******************************************************************************/
void	SPIInterrupt( void ) interrupt INT_NO_SPI0 using 1                       //SPIжϷ,ʹüĴ1
{ 
}
#endif

