
/********************************** (C) COPYRIGHT *******************************
* File Name          : ADC.C
* Author             : WCH
* Version            : V1.0
* Date               : 2017/01/20
* Description        : CH554 ADCʱãADCͨúѹȽģʽ 
*******************************************************************************/

#include "..\Public\CH554.H"                                                          
#include "..\Public\Debug.H"
#include "ADC.H"
#include "stdio.h"

#pragma  NOAREGS

#define ADC_INTERRUPT  1

/*******************************************************************************
* Function Name  : ADCInit(UINT8 div)
* Description    : ADCʱ,ģ鿪жϿ
* Input          : UINT8 div ʱ 
                   1   384Fosc                   								
                   0   96Fosc									 
* Output         : None
* Return         : None
*******************************************************************************/
void ADCInit(UINT8 div)
{
    ADC_CFG &= ~bADC_CLK | div;
    ADC_CFG |= bADC_EN;                                                        //ADCԴʹ
#if ADC_INTERRUPT
    ADC_IF = 0;                                                                //ж
    IE_ADC = 1;                                                                //ʹADCж
#endif
}

/*******************************************************************************
* Function Name  : ADC_ChannelSelect(UINT8 ch)
* Description    : ADC
* Input          : UINT8 ch ͨ
* Output         : None
* Return         : ɹ SUCCESS
                   ʧ FAIL
*******************************************************************************/
UINT8 ADC_ChannelSelect(UINT8 ch)
{
    if(ch == 0){ADC_CHAN1 =0;ADC_CHAN0=0;P1_DIR_PU &= ~bAIN0;}                 //AIN0
    else if(ch == 1){ADC_CHAN1 =0;ADC_CHAN0=1;P1_DIR_PU &= ~bAIN1;}            //AIN1
    else if(ch == 2){ADC_CHAN1 =1;ADC_CHAN0=0;P1_DIR_PU &= ~bAIN2;}            //AIN2
    else if(ch == 3){ADC_CHAN1 =1;ADC_CHAN0=1;P3_DIR_PU &= ~bAIN3;}            //AIN3
    else return FAIL;
    return SUCCESS;
}

/*******************************************************************************
* Function Name  : VoltageCMPModeInit()
* Description    : ѹȽģʽʼ
* Input          : UINT8 fo ˿ 0\1\2\3
                   UINT8 re ˿ 1\3
* Output         : None
* Return         : ɹ SUCCESS
                   ʧ FAIL
*******************************************************************************/
UINT8 VoltageCMPModeInit(UINT8 fo,UINT8 re)
{
    ADC_CFG |= bCMP_EN;                                                        //ƽȽϵԴʹ
    if(re == 1){
      if(fo == 0) {ADC_CHAN1 =0;ADC_CHAN0=0;CMP_CHAN =0;}                      //AIN0AIN1
      else if(fo == 2) {ADC_CHAN1 =1;ADC_CHAN0=0;CMP_CHAN =0;}                 //AIN2AIN1
      else if(fo == 3) {ADC_CHAN1 =1;ADC_CHAN0=1;CMP_CHAN =0; }                //AIN3AIN1			
      else return FAIL;
    }			     
    else if(re == 3){
      if(fo == 0) {ADC_CHAN1 =0;ADC_CHAN0=0;CMP_CHAN =0;}                      //AIN0AIN1
      else if(fo == 1) {ADC_CHAN1 =0;ADC_CHAN0=1;CMP_CHAN =0;}                 //AIN1AIN1
      else if(fo == 2) {ADC_CHAN1 =1;ADC_CHAN0=0;CMP_CHAN =0;}                 //AIN2AIN1			
      else return FAIL;
    }
    else return FAIL;
#if ADC_INTERRUPT
    CMP_IF = 0;                                                                //ж
    IE_ADC = 1;                                                                //ʹADCж
#endif

     return SUCCESS;
}

#if ADC_INTERRUPT
/*******************************************************************************
* Function Name  : ADCInterrupt(void)
* Description    : ADC жϷ
*******************************************************************************/
void	ADCInterrupt( void ) interrupt INT_NO_ADC using 1                       //ADCжϷ,ʹüĴ1
{ 
    if(ADC_IF ==  1)                                                          //ADCж
    { 
//      UserData = ADC_DATA;                                                    //ȡADC
      ADC_IF = 0;		                                                          //ADCжϱ־
    }
    if(CMP_IF ==  1)                                                          //ѹȽж
    {	
//       UserData = ADC_CTRL&0x80 >> 7);	                                        //Ƚ		
      CMP_IF = 0;		                                                          //ձȽж
    }
}
#endif

